/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.criteria;

import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.util.PageOrdering;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AlertCriteria
extends Criteria {
    private static final long serialVersionUID = 1L;
    private Integer filterId;
    private String filterTriggeredOperationName;
    private Long filterStartTime;
    private Long filterEndTime;
    private String filterName;
    private String filterDescription;
    private AlertPriority filterPriority;
    private String filterResourceTypeId;
    private String filterResourceTypeName;
    private List<Integer> filterResourceIds;
    private List<Integer> filterResourceGroupIds;
    private List<Integer> filterAlertDefinitionIds;
    private List<Integer> filterGroupAlertDefinitionIds;
    private boolean fetchAlertDefinition;
    private boolean fetchConditionLogs;
    private boolean fetchNotificationLogs;
    private PageOrdering sortName;
    private PageOrdering sortCtime;
    private PageOrdering sortPriority;

    public AlertCriteria() {
        super(Alert.class);
        this.filterOverrides.put("triggeredOperationName", "triggeredOperation like ?");
        this.filterOverrides.put("startTime", "ctime >= ?");
        this.filterOverrides.put("endTime", "ctime <= ?");
        this.filterOverrides.put("name", "alertDefinition.name like ?");
        this.filterOverrides.put("description", "alertDefinition.description like ?");
        this.filterOverrides.put("priority", "alertDefinition.priority = ?");
        this.filterOverrides.put("resourceTypeId", "alertDefinition.resource.resourceType.id = ?");
        this.filterOverrides.put("resourceTypeName", "alertDefinition.resource.resourceType.name like ?");
        this.filterOverrides.put("resourceIds", "alertDefinition.resource.id IN ( ? )");
        this.filterOverrides.put("resourceGroupIds", "alertDefinition.resource.id IN ( SELECT res.id     FROM ResourceGroup rg     JOIN rg.explicitResources res    WHERE rg.id = ? )");
        this.filterOverrides.put("alertDefinitionIds", "alertDefinition.id IN ( ? )");
        this.filterOverrides.put("groupAlertDefinitionIds", "alertDefinition.groupAlertDefinition.id IN ( ? )");
        this.sortOverrides.put("name", "alertDefinition.name");
        this.sortOverrides.put("priority", "alertDefinition.priority");
    }

    public void addFilterId(Integer filterId) {
        this.filterId = filterId;
    }

    public void addFilterTriggeredOperationName(String filterTriggeredOperationName) {
        this.filterTriggeredOperationName = filterTriggeredOperationName;
    }

    public void addFilterStartTime(Long filterStartTime) {
        this.filterStartTime = filterStartTime;
    }

    public void addFilterEndTime(Long filterEndTime) {
        this.filterEndTime = filterEndTime;
    }

    public void addFilterName(String filterName) {
        this.filterName = filterName;
    }

    public void addFilterDescription(String filterDescription) {
        this.filterDescription = filterDescription;
    }

    public void addFilterPriority(AlertPriority filterPriority) {
        this.filterPriority = filterPriority;
    }

    public void addFilterResourceTypeId(String filterResourceTypeId) {
        this.filterResourceTypeId = filterResourceTypeId;
    }

    public void addFilterResourceTypeName(String filterResourceTypeName) {
        this.filterResourceTypeName = filterResourceTypeName;
    }

    public void addFilterResourceIds(Integer ... filterResourceIds) {
        this.filterResourceIds = Arrays.asList(filterResourceIds);
    }

    public void addFilterResourceGroupIds(Integer ... filterResourceGroupIds) {
        this.filterResourceGroupIds = Arrays.asList(filterResourceGroupIds);
    }

    public void addFilterAlertDefinitionIds(Integer ... filterAlertDefinitionIds) {
        this.filterAlertDefinitionIds = Arrays.asList(filterAlertDefinitionIds);
    }

    public void addFilterGroupAlertDefinitionIds(Integer ... filterGroupAlertDefinitionIds) {
        this.filterGroupAlertDefinitionIds = Arrays.asList(filterGroupAlertDefinitionIds);
    }

    public void fetchAlertDefinition(boolean fetchAlertDefinition) {
        this.fetchAlertDefinition = fetchAlertDefinition;
    }

    public void fetchConditionLogs(boolean fetchConditionLogs) {
        this.fetchConditionLogs = fetchConditionLogs;
    }

    public void fetchNotificationLogs(boolean fetchNotificationLogs) {
        this.fetchNotificationLogs = fetchNotificationLogs;
    }

    public void addSortName(PageOrdering sortName) {
        this.addSortField("name");
        this.sortName = sortName;
    }

    public void addSortCtime(PageOrdering sortCtime) {
        this.addSortField("ctime");
        this.sortCtime = sortCtime;
    }

    public void addSortPriority(PageOrdering sortPriority) {
        this.addSortField("priority");
        this.sortPriority = sortPriority;
    }
}

