/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.operation;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.operation.HistoryJobId;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.operation.OperationRequestStatus;

@DiscriminatorColumn(name="DTYPE")
@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@NamedQueries(value={@NamedQuery(name="OperationHistory.findByJobId", query="SELECT h FROM OperationHistory h LEFT JOIN FETCH h.parameters  WHERE h.jobName = :jobName    AND h.jobGroup = :jobGroup    AND h.createdTime = :createdTime"), @NamedQuery(name="OperationHistory.getRecentlyCompletedResource_admin", query="SELECT DISTINCT new org.rhq.core.domain.operation.composite.ResourceOperationLastCompletedComposite(     ro.id,     ro.operationDefinition.displayName,     ro.createdTime,     ro.status,     ro.resource.id,     ro.resource.name,     ro.resource.resourceType.name)  FROM ResourceOperationHistory ro  WHERE ro.status != 'INPROGRESS'    AND ( ro.resource.id = :resourceId OR :resourceId IS NULL )"), @NamedQuery(name="OperationHistory.getRecentlyCompletedResource", query="SELECT DISTINCT new org.rhq.core.domain.operation.composite.ResourceOperationLastCompletedComposite(     ro.id,     ro.operationDefinition.displayName,     ro.createdTime,     ro.status,     ro.resource.id,     ro.resource.name,     ro.resource.resourceType.name)  FROM ResourceOperationHistory ro JOIN ro.resource.implicitGroups g JOIN g.roles r JOIN r.subjects s  WHERE ro.status != 'INPROGRESS' AND s = :subject    AND ( ro.resource.id = :resourceId OR :resourceId IS NULL )"), @NamedQuery(name="OperationHistory.getRecentlyCompletedGroup_admin", query="SELECT DISTINCT new org.rhq.core.domain.operation.composite.GroupOperationLastCompletedComposite(     go.id,     go.operationDefinition.displayName,     go.createdTime,     go.status,     go.group.id,     go.group.name,     go.group.resourceType.name)  FROM GroupOperationHistory go  WHERE go.status != 'INPROGRESS' "), @NamedQuery(name="OperationHistory.getRecentlyCompletedGroup", query="SELECT DISTINCT new org.rhq.core.domain.operation.composite.GroupOperationLastCompletedComposite(     go.id,     go.operationDefinition.displayName,     go.createdTime,     go.status,     go.group.id,     go.group.name,     go.group.resourceType.name)  FROM GroupOperationHistory go JOIN go.group g JOIN g.roles r JOIN r.subjects s  WHERE go.status != 'INPROGRESS' AND s = :subject "), @NamedQuery(name="OperationHistory.getParameterConfigurationIds", query="SELECT params.id   FROM OperationHistory oh   JOIN oh.parameters params  WHERE oh.id = :historyId"), @NamedQuery(name="OperationHistory.getResultConfigurationIds", query="SELECT res.id   FROM OperationHistory oh   JOIN oh.results res  WHERE oh.id = :historyId"), @NamedQuery(name="OperationHistory.deleteByHistoryIds", query="DELETE FROM OperationHistory oh  WHERE oh.id = :historyId ")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_OPERATION_HISTORY_ID_SEQ")
@Table(name="RHQ_OPERATION_HISTORY")
public abstract class OperationHistory
implements Serializable {
    public static final String QUERY_FIND_BY_JOB_ID = "OperationHistory.findByJobId";
    public static final String QUERY_GET_RECENTLY_COMPLETED_RESOURCE = "OperationHistory.getRecentlyCompletedResource";
    public static final String QUERY_GET_RECENTLY_COMPLETED_RESOURCE_ADMIN = "OperationHistory.getRecentlyCompletedResource_admin";
    public static final String QUERY_GET_RECENTLY_COMPLETED_GROUP = "OperationHistory.getRecentlyCompletedGroup";
    public static final String QUERY_GET_RECENTLY_COMPLETED_GROUP_ADMIN = "OperationHistory.getRecentlyCompletedGroup_admin";
    public static final String QUERY_GET_PARAMETER_CONFIGURATION_IDS = "OperationHistory.getParameterConfigurationIds";
    public static final String QUERY_GET_RESULT_CONFIGURATION_IDS = "OperationHistory.getResultConfigurationIds";
    public static final String QUERY_DELETE_BY_HISTORY_IDS = "OperationHistory.deleteByHistoryIds";
    private static final long serialVersionUID = 1L;
    @Column(name="ID")
    @GeneratedValue(generator="SEQ", strategy=GenerationType.AUTO)
    @Id
    private int id;
    @Column(name="JOB_NAME", nullable=false)
    private String jobName;
    @Column(name="JOB_GROUP", nullable=false)
    private String jobGroup;
    @Column(name="STATUS", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private OperationRequestStatus status;
    @Column(name="ERROR_MESSAGE")
    private String errorMessage;
    @Column(name="SUBJECT_NAME", nullable=false)
    private String subjectName;
    @Column(name="CTIME", nullable=false)
    private long createdTime = System.currentTimeMillis();
    @Column(name="STIME", nullable=false)
    private long startedTime;
    @Column(name="MTIME", nullable=false)
    private long modifiedTime = System.currentTimeMillis();
    @JoinColumn(name="OPERATION_DEF_ID", nullable=false)
    @ManyToOne(fetch=FetchType.EAGER)
    private OperationDefinition operationDefinition;
    @JoinColumn(name="PARAMETERS_CONFIG_ID", referencedColumnName="ID")
    @OneToOne(cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private Configuration parameters;

    protected OperationHistory() {
    }

    protected OperationHistory(String jobName, String jobGroup, String subjectName, OperationDefinition operationDefinition, Configuration parameters) {
        this.jobName = jobName;
        this.jobGroup = jobGroup;
        this.subjectName = subjectName;
        this.operationDefinition = operationDefinition;
        this.parameters = parameters;
        this.status = OperationRequestStatus.INPROGRESS;
    }

    public HistoryJobId getJobId() {
        return new HistoryJobId(this.jobName, this.jobGroup, this.createdTime);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobGroup() {
        return this.jobGroup;
    }

    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }

    public OperationDefinition getOperationDefinition() {
        return this.operationDefinition;
    }

    public void setOperationDefinition(OperationDefinition operationDefinition) {
        this.operationDefinition = operationDefinition;
    }

    public Configuration getParameters() {
        return this.parameters;
    }

    public void setParameters(Configuration parameters) {
        this.parameters = parameters;
    }

    public OperationRequestStatus getStatus() {
        return this.status;
    }

    public void setStatus(OperationRequestStatus status) {
        if (status == null) {
            throw new NullPointerException("status==null");
        }
        this.status = status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.errorMessage != null) {
            this.setStatus(OperationRequestStatus.FAILURE);
        }
    }

    public void setErrorMessageFromThrowable(Throwable t) {
        if (t != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(baos));
            this.setErrorMessage(baos.toString());
        } else {
            this.setErrorMessage(null);
        }
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public long getModifiedTime() {
        return this.modifiedTime;
    }

    public void setStartedTime() {
        if (this.startedTime != 0L) {
            throw new IllegalArgumentException("Can only start an operation once");
        }
        this.startedTime = System.currentTimeMillis();
    }

    public long getStartedTime() {
        return this.startedTime;
    }

    public long getDuration() {
        if (this.startedTime == 0L) {
            return 0L;
        }
        long start = this.startedTime;
        long end = this.modifiedTime;
        if (this.status == null || this.status == OperationRequestStatus.INPROGRESS) {
            end = System.currentTimeMillis();
        }
        return end - start;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("id=[" + this.id);
        buf.append("], job-name=[" + this.jobName);
        buf.append("], job-group=[" + this.jobGroup);
        buf.append("], status=[" + (Object)((Object)this.status));
        buf.append("], subject-name=[" + this.subjectName);
        if (Boolean.getBoolean("rhq.test.operation.show-values")) {
            buf.append("], parameters=[" + this.parameters);
        }
        buf.append("], ctime=[" + new Date(this.createdTime));
        buf.append("], mtime=[" + new Date(this.modifiedTime));
        buf.append("], duration-millis=[" + this.getDuration());
        String err = this.errorMessage;
        if (err != null && err.indexOf(10) > -1) {
            err = err.substring(0, err.indexOf(10)) + "...";
        }
        buf.append("], error-message=[" + err);
        return buf.toString();
    }

    public int hashCode() {
        return this.getJobId().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof OperationHistory)) {
            return false;
        }
        OperationHistory other = (OperationHistory)obj;
        return this.getJobId().equals(other.getJobId());
    }

    @PrePersist
    void onPersist() {
        this.modifiedTime = System.currentTimeMillis();
    }

    @PreUpdate
    void onUpdate() {
        this.modifiedTime = System.currentTimeMillis();
    }
}

