/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.resource.composite;

import java.io.Serializable;
import java.util.EnumSet;
import org.rhq.core.domain.resource.ResourceTypeFacet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFacets
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static ResourceFacets NONE = new ResourceFacets(-1, false, false, false, false, false, false, false, false);
    public static ResourceFacets ALL = new ResourceFacets(-1, true, true, true, true, true, true, true, true);
    private final int resourceTypeId;
    private final boolean measurement;
    private final boolean event;
    private final boolean pluginConfiguration;
    private final boolean configuration;
    private final boolean operation;
    private final boolean content;
    private final boolean callTime;
    private final boolean support;
    private EnumSet<ResourceTypeFacet> facets;

    public ResourceFacets(int resourceTypeId, boolean measurement, boolean event, boolean pluginConfiguration, boolean configuration, boolean operation, boolean content, boolean callTime, boolean support) {
        this.resourceTypeId = resourceTypeId;
        this.measurement = measurement;
        this.event = event;
        this.pluginConfiguration = pluginConfiguration;
        this.configuration = configuration;
        this.operation = operation;
        this.content = content;
        this.callTime = callTime;
        this.support = support;
        this.initEnum();
    }

    public ResourceFacets(int resourceTypeId, Number measurement, Number event, Number pluginConfiguration, Number configuration, Number operation, Number content, Number callTime, Number support) {
        this.resourceTypeId = resourceTypeId;
        this.measurement = measurement.intValue() != 0;
        this.event = event.intValue() != 0;
        this.pluginConfiguration = pluginConfiguration.intValue() != 0;
        this.configuration = configuration.intValue() != 0;
        this.operation = operation.intValue() != 0;
        this.content = content.intValue() != 0;
        this.callTime = callTime.intValue() != 0;
        this.support = support.intValue() != 0;
        this.initEnum();
    }

    public int getResourceTypeId() {
        return this.resourceTypeId;
    }

    public boolean isMeasurement() {
        return this.measurement;
    }

    public boolean isEvent() {
        return this.event;
    }

    public boolean isPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public boolean isConfiguration() {
        return this.configuration;
    }

    public boolean isOperation() {
        return this.operation;
    }

    public boolean isContent() {
        return this.content;
    }

    public boolean isCallTime() {
        return this.callTime;
    }

    public boolean isSupport() {
        return this.support;
    }

    public EnumSet<ResourceTypeFacet> getFacets() {
        return this.facets;
    }

    private void initEnum() {
        this.facets = EnumSet.noneOf(ResourceTypeFacet.class);
        if (this.measurement) {
            this.facets.add(ResourceTypeFacet.MEASUREMENT);
        }
        if (this.event) {
            this.facets.add(ResourceTypeFacet.EVENT);
        }
        if (this.pluginConfiguration) {
            this.facets.add(ResourceTypeFacet.PLUGIN_CONFIGURATION);
        }
        if (this.configuration) {
            this.facets.add(ResourceTypeFacet.CONFIGURATION);
        }
        if (this.operation) {
            this.facets.add(ResourceTypeFacet.OPERATION);
        }
        if (this.content) {
            this.facets.add(ResourceTypeFacet.CONTENT);
        }
        if (this.callTime) {
            this.facets.add(ResourceTypeFacet.CALL_TIME);
        }
        if (this.support) {
            this.facets.add(ResourceTypeFacet.SUPPORT);
        }
    }
}

