/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.search;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.search.SearchSubsystem;

@Entity
@SequenceGenerator(name="id", sequenceName="RHQ_SAVED_SEARCH_ID_SEQ")
@Table(name="RHQ_SAVED_SEARCH")
public class SavedSearch {
    @Id
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="id")
    private Integer id;
    @Column(name="CONTEXT", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private SearchSubsystem context;
    @Column(name="NAME")
    private String name;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="PATTERN", nullable=false)
    private String pattern;
    @Column(name="JPQL_TRANSLATION")
    private String jpqlTranslation;
    @Column(name="LAST_COMPUTE_TIME", nullable=false)
    private long lastComputeTime;
    @Column(name="RESULT_COUNT")
    private Long resultCount;
    @Column(name="SUBJECT_ID", nullable=false)
    private Subject subject;
    @Column(name="SUBJECT_ID", insertable=false, updatable=false)
    private int subjectId;
    @Column(name="GLOBAL", nullable=false)
    private boolean global;

    protected SavedSearch() {
    }

    public SavedSearch(SearchSubsystem context, String name, String pattern, Subject subject) {
        this.setContext(context);
        this.setPattern(pattern);
        this.setSubject(subject);
        this.setName(name);
        this.description = null;
        this.jpqlTranslation = null;
        this.lastComputeTime = 0L;
        this.resultCount = null;
        this.global = false;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public SearchSubsystem getContext() {
        return this.context;
    }

    private void setContext(SearchSubsystem context) {
        if (context == null) {
            throw new IllegalArgumentException("All saved searches must be bound to a SearchContext");
        }
        this.context = context;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        if (pattern == null || pattern.trim().equals("")) {
            throw new IllegalArgumentException("All saved searches must have a non-empty pattern");
        }
        this.pattern = pattern;
    }

    public String getJpqlTranslation() {
        return this.jpqlTranslation;
    }

    public void setJpqlTransation(String jpqlTranslation) {
        this.jpqlTranslation = jpqlTranslation;
    }

    public long getLastComputeTime() {
        return this.lastComputeTime;
    }

    public void setLastComputeTime(long lastComputeTime) {
        this.lastComputeTime = lastComputeTime;
    }

    public Long getResultCount() {
        return this.resultCount;
    }

    public void setResultCount(Long resultCount) {
        this.resultCount = resultCount;
    }

    public Subject getSubject() {
        return this.subject;
    }

    private void setSubject(Subject subject) {
        if (subject == null) {
            throw new IllegalArgumentException("All saved searches must be owned by a specific user");
        }
        this.subject = subject;
        this.subjectId = subject.getId();
    }

    public int getSubjectId() {
        return this.subjectId;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.subjectId;
        result = 31 * result + this.context.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.pattern.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof SavedSearch)) {
            return false;
        }
        SavedSearch other = (SavedSearch)obj;
        if (this.subjectId != other.subjectId) {
            return false;
        }
        if (this.context != other.context) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.pattern.equals(other.pattern);
    }
}

