/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.util;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.util.PageOrdering;

public class OrderingField
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String field;
    private PageOrdering ordering;

    protected OrderingField() {
    }

    public OrderingField(String field, PageOrdering ordering) {
        this.field = field;
        this.ordering = ordering != null ? ordering : PageOrdering.ASC;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        if (field == null) {
            throw new IllegalArgumentException("OrderingField.field can not be null");
        }
        this.field = field;
    }

    @NotNull
    public PageOrdering getOrdering() {
        return this.ordering;
    }

    public void setOrdering(PageOrdering ordering) {
        if (ordering == null) {
            throw new IllegalArgumentException("OrderingField.ordering can not be null");
        }
        this.ordering = ordering;
    }

    public void flipOrdering() {
        this.ordering = this.ordering == PageOrdering.ASC ? PageOrdering.DESC : PageOrdering.ASC;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderingField that = (OrderingField)o;
        if (!this.field.equals(that.field)) {
            return false;
        }
        return this.ordering == that.ordering;
    }

    public int hashCode() {
        int result = this.field.hashCode();
        result = 31 * result + this.ordering.hashCode();
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[field=" + this.field + ", ordering=" + (Object)((Object)this.ordering) + "]";
    }
}

