/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.core.server;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    private SecurityActions() {
    }

    static String getSystemProperty(final String key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key was null");
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
    }

    static String getEnvironmentVariable(final String key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key was null");
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getenv(key);
            }
        });
    }

    static void setJBossHomeSystemProperty(final String jbossHome) {
        assert (jbossHome != null && jbossHome.length() > 0) : "JBOSS_HOME must be specified";
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.setProperty("jboss.home", jbossHome);
                return null;
            }
        });
    }
}

