/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LazyStartupFilter
implements Filter {
    private final Log log = LogFactory.getLog(this.getClass());
    private volatile Filter filter;
    private volatile boolean initialized = false;
    private volatile FilterConfig config;

    public void destroy() {
        if (!this.initialized) {
            this.filter = null;
            this.config = null;
            return;
        }
        try {
            this.init();
        }
        catch (ServletException e) {
            this.log.error((Object)"Filter through an exception during init: ", (Throwable)e);
        }
        this.filter.destroy();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.init();
        this.filter.doFilter(request, response, chain);
    }

    private void init() throws ServletException {
        if (!this.initialized) {
            String parameter = this.getClass().getName();
            String filterName = this.config.getInitParameter(parameter);
            if (filterName == null) {
                throw new IllegalArgumentException("Filter was not specified using the " + parameter + " parameter");
            }
            this.log.debug((Object)("Loading filter" + filterName));
            try {
                this.filter = (Filter)Class.forName(filterName).newInstance();
            }
            catch (Exception e) {
                this.log.error((Object)("Could not instantiated filter: " + filterName), (Throwable)e);
            }
            this.filter.init(this.config);
            this.log.debug((Object)("Filter activated: " + this.filter));
            this.initialized = true;
        }
    }

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
    }
}

