/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.ui;

import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.embedded.EmbeddedInventoryEventListener;
import org.jboss.on.embedded.LoggingInventoryEventListener;
import org.jboss.on.embedded.bean.history.content.ContentHistoryManagerBean;
import org.jboss.on.embedded.bean.history.content.ContentServerServiceImpl;
import org.jboss.on.embedded.bean.history.operation.OperationServerServiceImpl;
import org.jboss.on.embedded.manager.ResourceManagerFactory;
import org.jboss.on.embedded.manager.history.operation.OperationHistoryManager;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.clientapi.server.content.ContentServerService;
import org.rhq.core.clientapi.server.operation.OperationServerService;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.ServerServices;
import org.rhq.core.pc.inventory.InventoryEventListener;
import org.rhq.core.pc.plugin.PluginEnvironment;
import org.rhq.core.pc.plugin.PluginFinder;
import org.rhq.core.pc.plugin.SimplePluginFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="bootstrapAction")
@Scope(value=ScopeType.APPLICATION)
@Startup
public class BootstrapAction {
    private static final Log LOG = LogFactory.getLog(BootstrapAction.class);
    private static final String FACES_API_LOGGER_NAME = "javax.faces";
    private static final String FACES_RI_LOGGER_NAME = "javax.enterprise.resource.webcontainer.jsf";
    private static final String FACELETS_LOGGER_NAME = "facelets";
    @In(value="historyManager", create=true)
    private OperationHistoryManager historyManager;
    @In(value="contentHistoryManager", create=true)
    private ContentHistoryManagerBean contentHistoryManager;
    @In(value="inventoryEventListener", create=true)
    private EmbeddedInventoryEventListener inventoryEventListener;
    private boolean initialized;
    private File tempDir;

    @Observer(value={"org.jboss.seam.security.loginSuccessful"})
    public void init() {
        if (!this.initialized) {
            try {
                String version = this.getVersion();
                LOG.info((Object)("Initializing Administration Console" + (version != null ? " v" + version : "") + "..."));
                long startTime = System.currentTimeMillis();
                BootstrapAction.reconfigureJdkLogging();
                this.initPluginContainer();
                ResourceManagerFactory.resourceManager().discoverResources();
                long elapsedTime = System.currentTimeMillis() - startTime;
                LOG.debug((Object)("Done initializing Administration Console (" + elapsedTime + " ms elapsed)."));
                this.initialized = true;
            }
            catch (Exception e) {
                LOG.error((Object)"*** Failed to initialize Administration Console. ***", (Throwable)e);
            }
        }
    }

    @Destroy
    public void shutdown() {
        if (this.initialized) {
            try {
                LOG.info((Object)"Shutting down Administration Console...");
                PluginContainer.getInstance().shutdown();
            }
            catch (RuntimeException e) {
                LOG.error((Object)"*** Failed to shutdown Administration Console. ***", (Throwable)e);
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    private void initPluginContainer() throws MalformedURLException {
        PluginContainerConfiguration pluginContainerConfig = this.createPluginContainerConfiguration();
        PluginContainer pluginContainer = PluginContainer.getInstance();
        pluginContainer.setConfiguration(pluginContainerConfig);
        BootstrapAction.configureMockScenarioLoader();
        pluginContainer.initialize();
        BootstrapAction.logLoadedPlugins(pluginContainer);
        pluginContainer.getInventoryManager().addInventoryEventListener((InventoryEventListener)this.inventoryEventListener);
        pluginContainer.getInventoryManager().addInventoryEventListener((InventoryEventListener)new LoggingInventoryEventListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String getVersion() {
        String version;
        block6: {
            version = null;
            try {
                version = this.getClass().getPackage().getImplementationVersion();
                if (version != null) break block6;
                String manifestPath = this.getRealPath("/META-INF/MANIFEST.MF");
                FileInputStream inputStream = new FileInputStream(manifestPath);
                try {
                    Manifest manifest = new Manifest(inputStream);
                    version = (String)manifest.getMainAttributes().get(Attributes.Name.IMPLEMENTATION_VERSION);
                    if (version == null) {
                        throw new IllegalStateException(Attributes.Name.IMPLEMENTATION_VERSION + " attribute is not set in WAR's manifest.");
                    }
                }
                finally {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Could not determine Administration Console version.", (Throwable)e);
            }
        }
        return version;
    }

    private String getRealPath(String webAppPath) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        return externalContext.getRealPath(webAppPath);
    }

    private static void reconfigureJdkLogging() {
        try {
            LOG.trace((Object)"Reconfiguring JDK logging...");
            BootstrapAction.setJdkLoggerLevel(FACES_API_LOGGER_NAME, Level.WARNING);
            BootstrapAction.setJdkLoggerLevel(FACES_RI_LOGGER_NAME, Level.WARNING);
            BootstrapAction.setJdkLoggerLevel(FACELETS_LOGGER_NAME, Level.WARNING);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to reconfigure JDK logging.", (Throwable)e);
        }
    }

    private PluginContainerConfiguration createPluginContainerConfiguration() throws MalformedURLException {
        PluginContainerConfiguration config = new PluginContainerConfiguration();
        config.setPluginFinder((PluginFinder)BootstrapAction.createPluginFinder());
        BootstrapAction.setPluginContainerDataDirectory(config);
        config.setTemporaryDirectory(this.initTempDir());
        config.setContentDiscoveryPeriod(0L);
        ServerServices services = new ServerServices();
        OperationServerServiceImpl callbackListener = new OperationServerServiceImpl();
        callbackListener.setHistoryBean(this.historyManager);
        ContentServerServiceImpl contentListener = new ContentServerServiceImpl();
        contentListener.setHistoryBean(this.contentHistoryManager);
        services.setOperationServerService((OperationServerService)callbackListener);
        services.setContentServerService((ContentServerService)contentListener);
        config.setServerServices(services);
        return config;
    }

    private static SimplePluginFinder createPluginFinder() throws MalformedURLException {
        SimplePluginFinder pluginFinder = new SimplePluginFinder();
        Set<String> pluginResourcePaths = BootstrapAction.getResourcePaths("/plugins/");
        for (String pluginResourcePath : pluginResourcePaths) {
            if (!pluginResourcePath.endsWith(".jar")) continue;
            URL pluginUrl = BootstrapAction.getResource(pluginResourcePath);
            pluginFinder.addUrl(pluginUrl);
        }
        return pluginFinder;
    }

    private static Set<String> getResourcePaths(String webAppPath) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        return externalContext.getResourcePaths(webAppPath);
    }

    private static URL getResource(String resourcePath) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        try {
            return externalContext.getResource(resourcePath);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void configureMockScenarioLoader() {
        LOG.trace((Object)"Configuring Mock Scenario Loader...");
        System.setProperty("on.mock.jboss.scenario", "scenario2.xml");
    }

    private static void logLoadedPlugins(PluginContainer pluginContainer) {
        Collection pluginEnvironments = pluginContainer.getPluginManager().getPlugins();
        for (PluginEnvironment pluginEnvironment : pluginEnvironments) {
            LOG.debug((Object)("Loaded RHQ plugin [" + pluginEnvironment.getPluginName() + "]."));
        }
    }

    private static void setJdkLoggerLevel(String name, Level level) {
        Logger facesApiLogger = Logger.getLogger(name);
        facesApiLogger.setLevel(level);
    }

    private static void setPluginContainerDataDirectory(PluginContainerConfiguration config) {
        File dataDirectory = BootstrapAction.getDirectory("jboss.server.data.dir");
        if (dataDirectory != null) {
            config.setDataDirectory(dataDirectory);
        }
    }

    private File initTempDir() {
        String baseTempDir;
        String jbasTempDir = System.getProperty("jboss.server.temp.dir");
        String javaTempDir = System.getProperty("java.io.tmpdir");
        String string = baseTempDir = jbasTempDir != null ? jbasTempDir : javaTempDir;
        if (baseTempDir == null) {
            baseTempDir = File.separatorChar == '/' ? "/tmp" : "C:/tmp";
        }
        this.tempDir = new File(baseTempDir, "embjopr");
        this.tempDir.mkdirs();
        if (!this.tempDir.exists()) {
            throw new IllegalStateException("Failed to initialize temporary directory: " + this.tempDir);
        }
        return this.tempDir;
    }

    @Nullable
    private static File getDirectory(String systemProperty) {
        File directory = null;
        String directoryPath = System.getProperty(systemProperty);
        if (directoryPath != null) {
            directory = new File(directoryPath);
        }
        return directory;
    }
}

