/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.util;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.resource.ResourceCreationDataType;
import org.rhq.core.domain.resource.ResourceType;

public abstract class ContentUtility {
    private static final Log LOG = LogFactory.getLog(ContentUtility.class);

    private ContentUtility() {
    }

    public static boolean isContentBacked(ResourceType resourceType) {
        return resourceType.isCreatable() && resourceType.getCreationDataType() == ResourceCreationDataType.CONTENT;
    }

    @Nullable
    public static PackageType getCreationPackageType(ResourceType resourceType) {
        PackageType creationPackageType = null;
        Set packageTypes = resourceType.getPackageTypes();
        for (PackageType packageType : packageTypes) {
            if (!packageType.isCreationData()) continue;
            creationPackageType = packageType;
            break;
        }
        LOG.debug((Object)("Creation package type for " + resourceType + " is " + creationPackageType + "."));
        return creationPackageType;
    }

    @Nullable
    public static Configuration getDefaultDeploymentConfiguration(PackageType packageType) {
        ConfigurationDefinition configurationDefinition = packageType.getDeploymentConfigurationDefinition();
        Configuration configuration = null;
        if (configurationDefinition != null) {
            configuration = configurationDefinition.getDefaultTemplate() != null ? configurationDefinition.getDefaultTemplate().getConfiguration() : new Configuration();
        }
        return configuration;
    }
}

