/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.asset;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;

public class ByteArrayAsset
implements Asset {
    private static final Logger log = Logger.getLogger(ByteArrayAsset.class.getName());
    private final byte[] content;

    public ByteArrayAsset(byte[] content) throws IllegalArgumentException {
        Validate.notNull(content, "content must be specified");
        int length = content.length;
        byte[] newArray = new byte[length];
        System.arraycopy(content, 0, newArray, 0, length);
        this.content = newArray;
        if (log.isLoggable(Level.FINER)) {
            log.finer("Created " + this + " with backing byte array of size " + length + "b");
        }
    }

    public ByteArrayAsset(InputStream stream) {
        this(IOUtil.asByteArray(stream));
    }

    public InputStream openStream() {
        return new ByteArrayInputStream(this.content);
    }

    public String toString() {
        return "ByteArrayAsset [content size=" + this.content.length + "bytes]";
    }
}

