/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.ejb;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.security.authorization.util.JBossXACMLUtil;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.xacml.core.model.context.ActionType;
import org.jboss.security.xacml.core.model.context.AttributeType;
import org.jboss.security.xacml.core.model.context.EnvironmentType;
import org.jboss.security.xacml.core.model.context.RequestType;
import org.jboss.security.xacml.core.model.context.ResourceType;
import org.jboss.security.xacml.core.model.context.SubjectType;
import org.jboss.security.xacml.factories.RequestAttributeFactory;
import org.jboss.security.xacml.factories.RequestResponseContextFactory;
import org.jboss.security.xacml.interfaces.RequestContext;

public class EJBXACMLUtil
extends JBossXACMLUtil {
    private static Logger log = Logger.getLogger(EJBXACMLUtil.class);
    private boolean trace = log.isTraceEnabled();

    public RequestContext createXACMLRequest(String ejbName, String methodName, Principal principal, RoleGroup callerRoles) throws Exception {
        if (principal == null) {
            throw new IllegalArgumentException("principal is null");
        }
        String action = methodName;
        RequestContext requestCtx = RequestResponseContextFactory.createRequestCtx();
        SubjectType subject = new SubjectType();
        subject.getAttribute().add(RequestAttributeFactory.createStringAttributeType((String)"urn:oasis:names:tc:xacml:1.0:subject:subject-id", (String)"jboss.org", (String)principal.getName()));
        List rolesList = callerRoles.getRoles();
        if (rolesList != null) {
            for (Role role : rolesList) {
                String roleName = role.getRoleName();
                AttributeType attSubjectID = RequestAttributeFactory.createStringAttributeType((String)"urn:oasis:names:tc:xacml:2.0:subject:role", (String)"jboss.org", (String)roleName);
                subject.getAttribute().add(attSubjectID);
            }
        }
        ResourceType resourceType = new ResourceType();
        resourceType.getAttribute().add(RequestAttributeFactory.createStringAttributeType((String)"urn:oasis:names:tc:xacml:1.0:resource:resource-id", null, (String)ejbName));
        ActionType actionType = new ActionType();
        actionType.getAttribute().add(RequestAttributeFactory.createStringAttributeType((String)"urn:oasis:names:tc:xacml:1.0:action:action-id", (String)"jboss.org", (String)action));
        EnvironmentType environmentType = new EnvironmentType();
        environmentType.getAttribute().add(RequestAttributeFactory.createDateTimeAttributeType((String)"urn:oasis:names:tc:xacml:1.0:environment:current-time", null));
        RequestType requestType = new RequestType();
        requestType.getSubject().add(subject);
        requestType.getResource().add(resourceType);
        requestType.setAction(actionType);
        requestType.setEnvironment(environmentType);
        requestCtx.setRequest(requestType);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.trace) {
            requestCtx.marshall((OutputStream)baos);
            log.trace((Object)new String(baos.toByteArray()));
        }
        return requestCtx;
    }
}

