/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.ResultSetIdentifierConsumer;
import org.hibernate.type.CustomType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdentifierGeneratorHelper {
    private static final Logger log = LoggerFactory.getLogger((Class)IdentifierGeneratorHelper.class);
    public static final Serializable SHORT_CIRCUIT_INDICATOR = new Serializable(){

        public String toString() {
            return "SHORT_CIRCUIT_INDICATOR";
        }
    };
    public static final Serializable POST_INSERT_INDICATOR = new Serializable(){

        public String toString() {
            return "POST_INSERT_INDICATOR";
        }
    };

    public static Serializable getGeneratedIdentity(ResultSet rs, Type type) throws SQLException, HibernateException {
        if (!rs.next()) {
            throw new HibernateException("The database returned no natively generated identity value");
        }
        Serializable id = IdentifierGeneratorHelper.get(rs, type);
        log.debug("Natively generated identity: " + id);
        return id;
    }

    public static Serializable get(ResultSet rs, Type type) throws SQLException, IdentifierGenerationException {
        CustomType customType;
        if (ResultSetIdentifierConsumer.class.isInstance(type)) {
            return ((ResultSetIdentifierConsumer)((Object)type)).consumeIdentifier(rs);
        }
        if (CustomType.class.isInstance(type) && ResultSetIdentifierConsumer.class.isInstance((customType = (CustomType)type).getUserType())) {
            return ((ResultSetIdentifierConsumer)((Object)customType.getUserType())).consumeIdentifier(rs);
        }
        Class clazz = type.getReturnedClass();
        if (clazz == Long.class) {
            return new Long(rs.getLong(1));
        }
        if (clazz == Integer.class) {
            return new Integer(rs.getInt(1));
        }
        if (clazz == Short.class) {
            return new Short(rs.getShort(1));
        }
        if (clazz == String.class) {
            return rs.getString(1);
        }
        throw new IdentifierGenerationException("this id generator generates long, integer, short or string");
    }

    public static Number createNumber(long value, Class clazz) throws IdentifierGenerationException {
        if (clazz == Long.class) {
            return new Long(value);
        }
        if (clazz == Integer.class) {
            return new Integer((int)value);
        }
        if (clazz == Short.class) {
            return new Short((short)value);
        }
        throw new IdentifierGenerationException("this id generator generates long, integer, short");
    }

    private IdentifierGeneratorHelper() {
    }
}

