/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.util;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BundleClassLoader
extends ClassLoader {
    private final Bundle bundle;

    public static BundleClassLoader createClassLoader(final Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Null bundle");
        }
        return AccessController.doPrivileged(new PrivilegedAction<BundleClassLoader>(){

            @Override
            public BundleClassLoader run() {
                return new BundleClassLoader(bundle);
            }
        });
    }

    private BundleClassLoader(Bundle bundle) {
        this.bundle = bundle;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.bundle.loadClass(name);
    }

    @Override
    protected URL findResource(String name) {
        return this.bundle.getResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.bundle.getResources(name);
    }

    @Override
    public URL getResource(String name) {
        return this.findResource(name);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.findClass(name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BundleClassLoader)) {
            return false;
        }
        BundleClassLoader bundleClassLoader = (BundleClassLoader)obj;
        return this.bundle.equals(bundleClassLoader.bundle);
    }

    public int hashCode() {
        return this.bundle.hashCode();
    }

    public String toString() {
        String shortName = this.bundle.getSymbolicName() + "-" + this.bundle.getVersion();
        return "BundleClassLoader[id=" + this.bundle.getBundleId() + "," + shortName + "]";
    }
}

