/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins.tracker;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.dependency.plugins.tracker.AbstractLockHolder;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.ControllerStateModel;
import org.jboss.dependency.spi.tracker.ContextFilter;
import org.jboss.dependency.spi.tracker.ContextQueries;
import org.jboss.dependency.spi.tracker.ContextRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractContextRegistry
extends AbstractLockHolder
implements ContextQueries,
ContextRegistry {
    private Map<Class<?>, ClassContext> contextsByClass = new HashMap();
    private Map<ControllerContext, Set<Class<?>>> classesByContext = new HashMap();
    private Controller controller;

    public AbstractContextRegistry(Controller controller) {
        if (controller == null) {
            throw new IllegalArgumentException("Null controller");
        }
        this.controller = controller;
    }

    @Override
    public ControllerContext getContext(Object name, ControllerState state) {
        return this.controller.getContext(name, state);
    }

    @Override
    public ControllerContext getInstalledContext(Object name) {
        return this.controller.getInstalledContext(name);
    }

    @Override
    public Set<ControllerContext> getNotInstalled() {
        return this.controller.getNotInstalled();
    }

    @Override
    public Set<ControllerContext> getContextsByState(ControllerState state) {
        return this.controller.getContextsByState(state);
    }

    @Override
    public Set<ControllerContext> filter(Iterable<ControllerContext> contexts, ContextFilter filter) {
        if (contexts == null) {
            return null;
        }
        HashSet<ControllerContext> set = new HashSet<ControllerContext>();
        for (ControllerContext context : contexts) {
            if (filter != null && !filter.accepts(context)) continue;
            set.add(context);
        }
        return set;
    }

    protected Set<ControllerContext> getContexts(Class<?> clazz) {
        ClassContext classContext = this.contextsByClass.get(clazz);
        if (classContext != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Marking class " + clazz + " as used."));
            }
            classContext.used = true;
            return classContext.contexts;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ControllerContext> getInstantiatedContexts(Class<?> clazz) {
        this.lockRead();
        try {
            Set<ControllerContext> contexts = this.getContexts(clazz);
            Set<ControllerContext> set = contexts != null && !contexts.isEmpty() ? Collections.unmodifiableSet(contexts) : null;
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ControllerContext> getContexts(Class<?> clazz, ControllerState state) {
        this.lockRead();
        try {
            Set<ControllerContext> contexts = this.getContexts(clazz);
            if (contexts != null && !contexts.isEmpty()) {
                ControllerStateModel model = this.controller.getStates();
                HashSet<ControllerContext> kccs = new HashSet<ControllerContext>();
                for (ControllerContext context : contexts) {
                    if (model.isBeforeState(context.getState(), state)) continue;
                    kccs.add(context);
                }
                HashSet<ControllerContext> hashSet = kccs;
                return hashSet;
            }
            Set<ControllerContext> set = null;
            return set;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public void addInstantiatedContext(ControllerContext context) {
        this.prepareToTraverse(context, true);
    }

    @Override
    public void registerInstantiatedContext(ControllerContext context, Class<?> ... classes) {
        this.handleInstantiatedContext(context, true, classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleInstantiatedContext(ControllerContext context, boolean addition, Class<?> ... classes) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (classes != null && classes.length > 0) {
            boolean trace = this.log.isTraceEnabled();
            this.lockWrite();
            try {
                for (Class<?> clazz : classes) {
                    this.handleContext(context, clazz, addition, trace);
                }
                if (addition) {
                    HashSet clazzes = new HashSet(Arrays.asList(classes));
                    this.classesByContext.put(context, clazzes);
                } else {
                    this.classesByContext.remove(context);
                }
            }
            finally {
                this.unlockWrite();
            }
        }
    }

    @Override
    public void unregisterInstantiatedContext(ControllerContext context, Class<?> ... classes) {
        this.handleInstantiatedContext(context, false, classes);
    }

    @Override
    public void removeInstantiatedContext(ControllerContext context) {
        this.prepareToTraverse(context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareToTraverse(ControllerContext context, boolean addition) {
        this.lockWrite();
        try {
            Object target = context.getTarget();
            if (target != null) {
                HashSet classes = addition ? new HashSet() : null;
                this.traverseBean(context, target.getClass(), addition, classes, this.log.isTraceEnabled());
                if (addition) {
                    this.classesByContext.put(context, classes);
                } else {
                    this.classesByContext.remove(context);
                }
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    protected void traverseBean(ControllerContext context, Class<?> clazz, boolean addition, Set<Class<?>> classes, boolean trace) {
        Class<?>[] interfaces;
        if (clazz == null || clazz == Object.class) {
            return;
        }
        this.handleContext(context, clazz, addition, trace);
        if (addition) {
            classes.add(clazz);
        }
        this.traverseBean(context, clazz.getSuperclass(), addition, classes, trace);
        for (Class<?> intface : interfaces = clazz.getInterfaces()) {
            this.traverseBean(context, intface, addition, classes, trace);
        }
    }

    protected void handleContext(ControllerContext context, Class<?> clazz, boolean addition, boolean trace) {
        ClassContext classContext = this.contextsByClass.get(clazz);
        if (addition) {
            if (classContext == null) {
                classContext = new ClassContext();
                classContext.contexts = new HashSet();
                this.contextsByClass.put(clazz, classContext);
            } else if (classContext.used) {
                this.log.debugf("Additional matching bean - contextual injection already used for class: %1s", new Object[]{clazz});
            }
            if (trace) {
                this.log.trace((Object)("Mapping contex " + context + " to class: " + clazz));
            }
            classContext.contexts.add(context);
        } else if (classContext != null) {
            if (trace) {
                this.log.trace((Object)("Removing contex " + context + " to class: " + clazz));
            }
            classContext.contexts.remove(context);
            if (classContext.contexts.isEmpty()) {
                this.contextsByClass.remove(clazz);
            }
        }
    }

    @Override
    public ControllerContext getContextByClass(Class<?> clazz) {
        Set<ControllerContext> contexts = this.getInstantiatedContexts(clazz);
        int numberOfMatchingBeans = 0;
        if (contexts != null) {
            numberOfMatchingBeans = contexts.size();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Checking for contextual injection, current matches: " + numberOfMatchingBeans + " - " + clazz));
        }
        if (numberOfMatchingBeans != 1) {
            if (numberOfMatchingBeans > 1) {
                this.log.warn((Object)("Multiple beans match class type [enable trace log for details]: " + clazz));
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Matching contexts: " + contexts));
                }
            }
            return null;
        }
        return contexts.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Class<?>> getExposedClasses(ControllerContext context) {
        this.lockRead();
        try {
            Set<Class<?>> result = this.classesByContext.get(context);
            HashSet hashSet = result == null ? Collections.emptySet() : new HashSet(result);
            return hashSet;
        }
        finally {
            this.unlockRead();
        }
    }

    private static class ClassContext {
        private boolean used;
        private Set<ControllerContext> contexts;

        private ClassContext() {
        }
    }
}

