/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api;

import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.Configuration;
import org.jboss.shrinkwrap.api.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArchiveFactory {
    private static final String ARCHIVE_IMPL = "org.jboss.shrinkwrap.impl.base.MemoryMapArchiveImpl";
    private final Configuration configuration;

    ArchiveFactory(Configuration configuration) throws IllegalArgumentException {
        assert (configuration != null) : "configuration must be supplied";
        this.configuration = configuration;
    }

    public <T extends Assignable> T create(String archiveName, Class<T> type) throws IllegalArgumentException {
        if (archiveName == null) {
            throw new IllegalArgumentException("ArchiveName must be specified");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type must be specified");
        }
        Archive archive = SecurityActions.newInstance(ARCHIVE_IMPL, new Class[]{String.class, Configuration.class}, new Object[]{archiveName, this.configuration}, Archive.class);
        return archive.as(type);
    }
}

