/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.jndi;

import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEModuleInformer;
import org.jboss.reloaded.naming.spi.JavaEEModule;
import org.jboss.weld.integration.deployer.DeployersUtils;
import org.jboss.weld.integration.deployer.jndi.JavaEEModuleJndiBinder;
import org.jboss.weld.integration.deployer.jndi.SimpleCompJndiBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebJndiBinderDeployer
extends AbstractSimpleRealDeployer<JBossWebMetaData> {
    private JavaEEModuleInformer informer;

    public WebJndiBinderDeployer(JavaEEModuleInformer javaEEModuleInformer) {
        super(JBossWebMetaData.class);
        this.informer = javaEEModuleInformer;
        this.setOutput(BeanMetaData.class);
    }

    public void deploy(DeploymentUnit deploymentUnit, JBossWebMetaData jBossWebMetaData) throws DeploymentException {
        BeanMetaData bbBMD = this.getBootstrapBeanAttachment(deploymentUnit.getTopLevel());
        if (bbBMD != null && this.informer.getModuleType(deploymentUnit).equals((Object)JavaEEModuleInformer.ModuleType.WEB)) {
            BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)(deploymentUnit.getName() + "_WebCompJndiBinder"), (String)SimpleCompJndiBinder.class.getName());
            builder.addConstructorParameter(String.class.getName(), deploymentUnit.getName());
            builder.addInstall("bindToJavaComp");
            builder.addUninstall("unbind");
            deploymentUnit.getTopLevel().addAttachment(deploymentUnit.getName() + "_WebCompJndiBinder", (Object)builder.getBeanMetaData());
            BeanMetaDataBuilder moduleBinderBuilder = BeanMetaDataBuilder.createBuilder((String)(deploymentUnit.getName() + "_JavaModuleJndiBinder"), (String)JavaEEModuleJndiBinder.class.getName());
            AbstractInjectionValueMetaData javaModule = new AbstractInjectionValueMetaData((Object)this.getModuleBeanName(deploymentUnit));
            moduleBinderBuilder.addConstructorParameter(JavaEEModule.class.getName(), (ValueMetaData)javaModule);
            moduleBinderBuilder.addConstructorParameter(String.class.getName(), deploymentUnit.getName());
            moduleBinderBuilder.addInstall("bindToJavaComp");
            moduleBinderBuilder.addUninstall("unbind");
            deploymentUnit.getTopLevel().addAttachment(deploymentUnit.getName() + "_JavaModuleJndiBinder", (Object)moduleBinderBuilder.getBeanMetaData());
        }
    }

    private BeanMetaData getBootstrapBeanAttachment(DeploymentUnit deploymentUnit) {
        String bootstrapName = DeployersUtils.getBootstrapBeanName(deploymentUnit.getTopLevel());
        String bbAttachmentName = bootstrapName + "_" + BeanMetaData.class.getSimpleName();
        BeanMetaData bbBMD = (BeanMetaData)deploymentUnit.getTopLevel().getAttachment(bbAttachmentName, BeanMetaData.class);
        return bbBMD;
    }

    private String getModuleBeanName(DeploymentUnit deploymentUnit) {
        String appName = this.informer.getApplicationName(deploymentUnit);
        String moduleName = this.informer.getModulePath(deploymentUnit);
        String name = "jboss.naming:";
        if (appName != null) {
            name = name + "application=" + appName + ",";
        }
        name = name + "module=" + moduleName;
        return name;
    }
}

