/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.annotation.security.RunAs;
import javax.ejb.ApplicationException;
import javax.ejb.EJB;
import javax.ejb.EJBs;
import javax.ejb.Init;
import javax.ejb.Local;
import javax.ejb.LocalHome;
import javax.ejb.MessageDriven;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remote;
import javax.ejb.RemoteHome;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionManagement;
import javax.interceptor.AroundInvoke;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.interceptor.Interceptors;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContexts;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.WebServiceRefs;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployment.AnnotationMetaDataDeployer;
import org.jboss.mcann.AnnotationRepository;
import org.jboss.mcann.Element;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AltAnnotationMetaDataDeployer
extends AnnotationMetaDataDeployer {
    private Set<Class<? extends Annotation>> annotationOnClass = new HashSet<Class<? extends Annotation>>();
    private Set<Class<? extends Annotation>> annotationOnMethod = new HashSet<Class<? extends Annotation>>();
    private Set<Class<? extends Annotation>> annotationOnField = new HashSet<Class<? extends Annotation>>();

    public AltAnnotationMetaDataDeployer() {
        this.setInput(AnnotationRepository.class);
        this.addAnnotationClass(Stateful.class);
        this.addAnnotationClass(Remove.class);
        this.addAnnotationClass(PostActivate.class);
        this.addAnnotationClass(PrePassivate.class);
        this.addAnnotationClass(Local.class);
        this.addAnnotationClass(LocalHome.class);
        this.addAnnotationClass(Remote.class);
        this.addAnnotationClass(RemoteHome.class);
        this.addAnnotationClass(Init.class);
        this.addAnnotationClass(Timeout.class);
        this.addAnnotationClass(AroundInvoke.class);
        this.addAnnotationClass(TransactionManagement.class);
        this.addAnnotationClass(TransactionAttribute.class);
        this.addAnnotationClass(RunAs.class);
        this.addAnnotationClass(DeclareRoles.class);
        this.addAnnotationClass(DenyAll.class);
        this.addAnnotationClass(RolesAllowed.class);
        this.addAnnotationClass(PermitAll.class);
        this.addAnnotationClass(Interceptors.class);
        this.addAnnotationClass(ExcludeClassInterceptors.class);
        this.addAnnotationClass(ExcludeDefaultInterceptors.class);
        this.addAnnotationClass(Resource.class);
        this.addAnnotationClass(Resources.class);
        this.addAnnotationClass(EJB.class);
        this.addAnnotationClass(EJBs.class);
        this.addAnnotationClass(PersistenceContext.class);
        this.addAnnotationClass(PersistenceContexts.class);
        this.addAnnotationClass(PostConstruct.class);
        this.addAnnotationClass(PreDestroy.class);
        this.addAnnotationClass(WebServiceRef.class);
        this.addAnnotationClass(WebServiceRefs.class);
        this.addAnnotationClass(Stateless.class);
        this.addAnnotationClass(MessageDriven.class);
        this.addAnnotationClass(Entity.class);
        this.addAnnotationClass(ApplicationException.class);
    }

    protected Collection<Class<?>> getClasses(VFSDeploymentUnit unit, String mainClassName, List<VirtualFile> classpath) throws IOException {
        Set elements;
        Class<? extends Annotation> annotationClass;
        Class<? extends Annotation> annotation;
        AnnotationRepository env = (AnnotationRepository)unit.getAttachment(AnnotationRepository.class);
        if (env == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Cannot scan classes, missing AnnotationRepository as attachment: " + unit.getName()));
            }
            return Collections.emptySet();
        }
        HashSet classes = new HashSet();
        Iterator<Class<? extends Annotation>> i$ = this.annotationOnClass.iterator();
        while (i$.hasNext()) {
            annotationClass = annotation = i$.next();
            elements = env.classIsAnnotatedWith(annotationClass);
            for (Element elt : elements) {
                classes.add(elt.getOwner());
            }
        }
        i$ = this.annotationOnMethod.iterator();
        while (i$.hasNext()) {
            annotationClass = annotation = i$.next();
            elements = env.classHasMethodAnnotatedWith(annotationClass);
            for (Element elt : elements) {
                classes.add(elt.getOwner());
            }
        }
        i$ = this.annotationOnField.iterator();
        while (i$.hasNext()) {
            annotationClass = annotation = i$.next();
            elements = env.classHasFieldAnnotatedWith(annotationClass);
            for (Element elt : elements) {
                classes.add(elt.getOwner());
            }
        }
        if (this.log.isTraceEnabled() && !classes.isEmpty()) {
            this.log.trace((Object)("Annotated classes: " + classes));
        }
        return classes;
    }

    public void stop() {
        this.annotationOnClass.clear();
        this.annotationOnMethod.clear();
        this.annotationOnField.clear();
    }

    public void addAnnotationClass(Class<? extends Annotation> annotation) {
        Target target = annotation.getAnnotation(Target.class);
        if (target == null) {
            this.log.info((Object)("Annotation " + annotation + " has not @Target."));
            return;
        }
        ElementType[] types = target.value();
        if (types == null || types.length == 0) {
            this.log.info((Object)("Null or empty types on annotation's @Target: " + annotation));
            return;
        }
        for (ElementType type : types) {
            boolean used = false;
            if (type == ElementType.TYPE) {
                this.annotationOnClass.add(annotation);
                used = true;
            }
            if (!used && type == ElementType.METHOD) {
                this.annotationOnMethod.add(annotation);
                used = true;
            }
            if (used || type != ElementType.FIELD) continue;
            this.annotationOnField.add(annotation);
        }
    }
}

