/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.ws.addressing.EndpointReference;
import org.jboss.logging.Logger;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.MessageTrace;
import org.jboss.ws.core.client.EndpointInfo;
import org.jboss.ws.core.client.RemoteConnection;
import org.jboss.ws.core.client.transport.NettyClient;
import org.jboss.ws.extensions.wsrm.transport.RMChannel;
import org.jboss.ws.extensions.wsrm.transport.RMMetadata;
import org.jboss.ws.extensions.wsrm.transport.RMTransportHelper;

public abstract class HTTPRemotingConnection
implements RemoteConnection {
    private static Logger log = Logger.getLogger(HTTPRemotingConnection.class);
    private boolean closed;
    private Integer chunkSize;
    private static final RMChannel RM_CHANNEL = RMChannel.getInstance();

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public Integer getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(Integer chunkSize) {
        this.chunkSize = chunkSize;
    }

    @Override
    public MessageAbstraction invoke(MessageAbstraction reqMessage, Object endpoint, boolean oneway) throws IOException {
        String targetAddress;
        if (endpoint == null) {
            throw new IllegalArgumentException("Given endpoint cannot be null");
        }
        if (this.closed) {
            throw new IOException("Connection is already closed");
        }
        Map<String, Object> callProps = new HashMap<String, Object>();
        if (endpoint instanceof EndpointInfo) {
            EndpointInfo epInfo = (EndpointInfo)endpoint;
            targetAddress = epInfo.getTargetAddress();
            callProps = epInfo.getProperties();
        } else if (endpoint instanceof EndpointReference) {
            EndpointReference epr = (EndpointReference)endpoint;
            targetAddress = epr.getAddress().toString();
        } else {
            targetAddress = endpoint.toString();
        }
        if (RMTransportHelper.isRMMessage(callProps)) {
            try {
                HashMap<String, Object> additionalHeaders = new HashMap<String, Object>();
                this.populateHeaders(reqMessage, additionalHeaders);
                RMMetadata rmMetadata = new RMMetadata(targetAddress, this.getMarshaller(), this.getUnmarshaller(), callProps, additionalHeaders);
                return RM_CHANNEL.send(reqMessage, rmMetadata);
            }
            catch (Throwable t) {
                IOException io = new IOException();
                io.initCause(t);
                throw io;
            }
        }
        NettyClient client = new NettyClient(this.getMarshaller(), this.getUnmarshaller());
        if (this.chunkSize != null) {
            client.setChunkSize(this.chunkSize);
        }
        HashMap<String, Object> additionalHeaders = new HashMap<String, Object>();
        this.populateHeaders(reqMessage, additionalHeaders);
        MessageTrace.traceMessage("Outgoing Request Message", reqMessage);
        MessageAbstraction resMessage = (MessageAbstraction)client.invoke(reqMessage, targetAddress, oneway, additionalHeaders, callProps);
        MessageTrace.traceMessage("Incoming Response Message", resMessage);
        return resMessage;
    }

    protected void populateHeaders(MessageAbstraction reqMessage, Map<String, Object> metadata) {
        if (reqMessage != null) {
            MimeHeaders mimeHeaders = reqMessage.getMimeHeaders();
            Iterator i = mimeHeaders.getAllHeaders();
            while (i.hasNext()) {
                MimeHeader header = (MimeHeader)i.next();
                String hName = header.getName();
                Object currentValue = metadata.get(hName);
                if (currentValue != null) {
                    metadata.put(hName, currentValue + "," + header.getValue());
                    continue;
                }
                metadata.put(hName, header.getValue());
            }
        }
    }
}

