/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.wsaddressing;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import org.jboss.wsf.common.DOMUtils;
import org.w3c.dom.Element;

@XmlRootElement(name="EndpointReference", namespace="http://www.w3.org/2005/08/addressing")
@XmlType(name="EndpointReferenceType", namespace="http://www.w3.org/2005/08/addressing")
public final class NativeEndpointReference
extends EndpointReference {
    protected static final String WSA_NS = "http://www.w3.org/2005/08/addressing";
    private static final String WSAM_NS = "http://www.w3.org/2007/05/addressing/metadata";
    private static final QName SERVICE_QNAME = new QName("http://www.w3.org/2007/05/addressing/metadata", "ServiceName", "wsam");
    private static final QName INTERFACE_QNAME = new QName("http://www.w3.org/2007/05/addressing/metadata", "InterfaceName", "wsam");
    private static final QName WSDL_LOCATION_QNAME = new QName("wsdlLocation");
    private static final String ENDPOINT_ATTRIBUTE = "EndpointName";
    private static final JAXBContext jc = NativeEndpointReference.getJaxbContext();
    @XmlElement(name="Address", namespace="http://www.w3.org/2005/08/addressing")
    private Address address;
    @XmlElement(name="ReferenceParameters", namespace="http://www.w3.org/2005/08/addressing")
    private Elements referenceParameters;
    @XmlElement(name="Metadata", namespace="http://www.w3.org/2005/08/addressing")
    private Elements metadata;
    @XmlAnyAttribute
    private Map<QName, String> attributes;
    @XmlAnyElement
    private List<Element> elements;
    private QName serviceName;
    private Element serviceNameElement;
    private QName endpointName;
    private QName interfaceName;
    private String wsdlLocation;

    public NativeEndpointReference() {
    }

    public NativeEndpointReference(Source source) {
        try {
            NativeEndpointReference epr = (NativeEndpointReference)((Object)jc.createUnmarshaller().unmarshal(source, NativeEndpointReference.class).getValue());
            this.address = epr.address;
            if (epr.referenceParameters != null && !epr.referenceParameters.isEmpty()) {
                this.referenceParameters = epr.referenceParameters;
            }
            if (epr.metadata != null && !epr.metadata.isEmpty()) {
                this.metadata = epr.metadata;
            }
            this.attributes = epr.attributes;
            this.elements = epr.elements;
            if (epr.metadata != null) {
                List<Element> metadataElements;
                String wsdlLocation;
                Map<QName, String> metadataAttributes = epr.metadata.getAttributes();
                if (metadataAttributes != null && (wsdlLocation = metadataAttributes.get(WSDL_LOCATION_QNAME)) != null) {
                    this.setWsdlLocation(wsdlLocation);
                }
                if ((metadataElements = epr.metadata.getElements()) != null) {
                    for (Element e : epr.metadata.getElements()) {
                        if (!WSAM_NS.equals(e.getNamespaceURI())) continue;
                        if (e.getLocalName().equals(SERVICE_QNAME.getLocalPart())) {
                            this.serviceName = this.getQName(e, e.getTextContent());
                            String endpointName = e.getAttribute(ENDPOINT_ATTRIBUTE);
                            if (endpointName != null) {
                                this.endpointName = this.getQName(e, endpointName);
                            }
                        }
                        if (!e.getLocalName().equals(INTERFACE_QNAME.getLocalPart())) continue;
                        this.interfaceName = this.getQName(e, e.getTextContent());
                    }
                }
            }
        }
        catch (JAXBException e) {
            throw new WebServiceException("Error unmarshalling NativeEndpointReference ", (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new WebServiceException("Source did not contain NativeEndpointReference", (Throwable)e);
        }
    }

    @XmlTransient
    public String getAddress() {
        return this.address != null ? this.address.getUri() : null;
    }

    public void setAddress(String address) {
        if (address == null) {
            return;
        }
        this.address = new Address(address);
    }

    @XmlTransient
    public QName getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(QName serviceName) {
        if (serviceName == null) {
            return;
        }
        this.serviceName = serviceName;
        this.serviceNameElement = DOMUtils.createElement((QName)SERVICE_QNAME);
        String attrName = this.getNamespaceAttributeName(serviceName.getPrefix());
        this.serviceNameElement.setAttribute(attrName, serviceName.getNamespaceURI());
        this.serviceNameElement.setTextContent(this.toString(serviceName));
        if (this.metadata == null) {
            this.metadata = new Elements();
        }
        this.metadata.addElement(this.serviceNameElement);
    }

    @XmlTransient
    public QName getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointName(QName endpointName) {
        if (endpointName == null) {
            return;
        }
        this.endpointName = endpointName;
    }

    @XmlTransient
    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(QName interfaceName) {
        if (interfaceName == null) {
            return;
        }
        this.interfaceName = interfaceName;
        Element interfaceNameElement = DOMUtils.createElement((QName)INTERFACE_QNAME);
        String attrName = this.getNamespaceAttributeName(interfaceName.getPrefix());
        interfaceNameElement.setAttribute(attrName, interfaceName.getNamespaceURI());
        interfaceNameElement.setTextContent(this.toString(interfaceName));
        if (this.metadata == null) {
            this.metadata = new Elements();
        }
        this.metadata.addElement(interfaceNameElement);
    }

    @XmlTransient
    public List<Element> getMetadata() {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.getElements();
    }

    public void setMetadata(List<Element> metadata) {
        if (metadata == null || metadata.size() == 0) {
            return;
        }
        if (this.metadata == null) {
            this.metadata = new Elements();
        }
        this.metadata.setElements(metadata);
    }

    @XmlTransient
    public URL getWsdlLocation() {
        if (this.wsdlLocation != null) {
            return this.toURL(this.wsdlLocation);
        }
        String address = this.getAddress();
        if (address != null) {
            return this.toURL(address + "?wsdl");
        }
        return null;
    }

    public void setWsdlLocation(String wsdlLocation) {
        if (wsdlLocation == null) {
            return;
        }
        this.wsdlLocation = wsdlLocation;
        if (this.metadata == null) {
            this.metadata = new Elements();
        }
        this.metadata.addAttribute(WSDL_LOCATION_QNAME, wsdlLocation);
    }

    @XmlTransient
    public List<Element> getReferenceParameters() {
        if (this.referenceParameters == null) {
            return null;
        }
        return this.referenceParameters.getElements();
    }

    public void setReferenceParameters(List<Element> metadata) {
        if (metadata == null || metadata.size() == 0) {
            return;
        }
        if (this.referenceParameters == null) {
            this.referenceParameters = new Elements();
        }
        this.referenceParameters.setElements(metadata);
    }

    public static EndpointReference readFrom(Source eprInfoset) {
        if (eprInfoset == null) {
            throw new NullPointerException("Provided eprInfoset cannot be null");
        }
        try {
            return new NativeEndpointReference(eprInfoset);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public void writeTo(Result result) {
        if (this.endpointName != null && this.serviceNameElement != null) {
            this.serviceNameElement.setAttribute(ENDPOINT_ATTRIBUTE, this.toString(this.endpointName));
        }
        try {
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.marshal((Object)this, result);
        }
        catch (JAXBException e) {
            throw new WebServiceException("Error marshalling NativeEndpointReference. ", (Throwable)e);
        }
    }

    private URL toURL(String s) {
        try {
            return new URL(s);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static JAXBContext getJaxbContext() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{NativeEndpointReference.class});
        }
        catch (JAXBException ex) {
            throw new WebServiceException("Cannot obtain JAXB context", (Throwable)ex);
        }
    }

    private String toString(QName qname) {
        StringBuilder sb = new StringBuilder();
        if (qname.getPrefix() != null && qname.getPrefix().length() > 0) {
            sb.append(qname.getPrefix());
            sb.append(':');
        }
        sb.append(qname.getLocalPart());
        return sb.toString();
    }

    private QName getQName(Element e, String nodeValue) {
        if (nodeValue == null) {
            throw new RuntimeException("Missing text content for element: " + e.getNodeName());
        }
        int separatorIndex = nodeValue.indexOf(58);
        if (separatorIndex == -1) {
            String namespace = e.getAttribute("xmlns");
            return new QName(namespace, nodeValue);
        }
        String prefix = nodeValue.substring(0, separatorIndex);
        String localPart = nodeValue.substring(separatorIndex + 1);
        String namespace = e.lookupNamespaceURI(prefix);
        return new QName(namespace, localPart, prefix);
    }

    private String getNamespaceAttributeName(String prefix) {
        if (prefix == null || "".equals(prefix)) {
            return "xmlns";
        }
        return "xmlns:" + prefix;
    }

    private static class Elements {
        @XmlAnyElement
        List<Element> elements;
        @XmlAnyAttribute
        Map<QName, String> attributes;

        protected Elements() {
        }

        public Elements(List<Element> elements) {
            this.elements = elements;
        }

        @XmlTransient
        public List<Element> getElements() {
            return this.elements;
        }

        public void setElements(List<Element> elements) {
            if (this.elements == null) {
                this.elements = elements;
            } else {
                this.elements.addAll(elements);
            }
        }

        public void addElement(Element e) {
            if (this.elements == null) {
                this.elements = new LinkedList<Element>();
            }
            this.elements.add(e);
        }

        @XmlTransient
        public Map<QName, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<QName, String> attributes) {
            if (this.attributes == null) {
                this.attributes = attributes;
            } else {
                this.attributes.putAll(attributes);
            }
        }

        public void addAttribute(QName attrName, String attrValue) {
            if (this.attributes == null) {
                this.attributes = new HashMap<QName, String>();
            }
            this.attributes.put(attrName, attrValue);
        }

        @XmlTransient
        public boolean isEmpty() {
            boolean noAttributes = this.attributes == null || this.attributes.size() == 0;
            boolean noElements = this.elements == null || this.elements.size() == 0;
            return noAttributes && noElements;
        }
    }

    private static class Address {
        @XmlValue
        String uri;
        @XmlAnyAttribute
        Map<QName, String> attributes;

        protected Address() {
        }

        public Address(String uri) {
            this.uri = uri;
        }

        @XmlTransient
        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        @XmlTransient
        public Map<QName, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<QName, String> attributes) {
            this.attributes = attributes;
        }
    }
}

