/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.server;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AddressingProperties;
import javax.xml.ws.addressing.Relationship;
import javax.xml.ws.addressing.soap.SOAPAddressingProperties;
import org.jboss.logging.Logger;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.extensions.wsrm.RMAddressingConstants;
import org.jboss.ws.extensions.wsrm.RMFault;
import org.jboss.ws.extensions.wsrm.RMFaultCode;
import org.jboss.ws.extensions.wsrm.common.RMHelper;
import org.jboss.ws.extensions.wsrm.protocol.RMConstants;
import org.jboss.ws.extensions.wsrm.protocol.RMProvider;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMCloseSequence;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMCreateSequence;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSequence;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSequenceAcknowledgement;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSerializable;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMTerminateSequence;
import org.jboss.ws.extensions.wsrm.server.RMServerSequence;
import org.jboss.ws.extensions.wsrm.server.RMStore;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.Invocation;
import org.jboss.wsf.spi.invocation.InvocationHandler;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;

public final class RMInvocationHandler
extends InvocationHandler {
    private static final Logger logger = Logger.getLogger(RMInvocationHandler.class);
    private static final RMConstants rmConstants = RMProvider.get().getConstants();
    private ServerConfig serverConfig;
    private final InvocationHandler delegate;
    private final ArchiveDeployment dep;
    private final String dataDir;

    RMInvocationHandler(InvocationHandler delegate, ArchiveDeployment dep) {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.serverConfig = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
        this.delegate = delegate;
        this.dep = dep;
        this.dataDir = this.getPersistLocation();
    }

    private String getPersistLocation() {
        try {
            String deploymentDir = this.dep.getParent() != null ? this.dep.getParent().getSimpleName() : this.dep.getSimpleName();
            return this.serverConfig.getServerDataDir().getCanonicalPath() + "/wsrm/" + deploymentDir;
        }
        catch (IOException ioe) {
            throw new IllegalStateException();
        }
    }

    public final Invocation createInvocation() {
        return this.delegate.createInvocation();
    }

    public final void handleInvocationException(Throwable th) throws Exception {
        super.handleInvocationException(th);
    }

    public final void init(Endpoint ep) {
        this.delegate.init(ep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Map<String, Object> prepareResponseContext(Endpoint ep, Invocation inv, String dataDir) {
        String seqIdentifier;
        RMSerializable payload;
        Map data;
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        Map rmReqProps = (Map)msgContext.get("wsrm.requestContext");
        msgContext.remove("wsrm.requestContext");
        if (rmReqProps == null) {
            throw new RMFault(RMFaultCode.WSRM_REQUIRED);
        }
        AddressingProperties addrProps = (AddressingProperties)msgContext.get("javax.xml.ws.addressing.context.inbound");
        if (addrProps == null) {
            throw new IllegalStateException("WS-Addressing properties not found in server request");
        }
        LinkedList<QName> protocolMessages = new LinkedList<QName>();
        HashMap<String, Object> rmResponseContext = new HashMap<String, Object>();
        rmResponseContext.put("wsrm.protocolMessages", protocolMessages);
        msgContext.remove("wsrm.responseContext");
        RMServerSequence sequence = null;
        boolean isOneWayOperation = true;
        if (RMHelper.isCreateSequence(rmReqProps)) {
            data = (Map)rmReqProps.get("wsrm.protocolMessagesMapping");
            RMCreateSequence rmCreateSequence = (RMCreateSequence)data.get(rmConstants.getCreateSequenceQName());
            sequence = rmCreateSequence.getOffer() != null ? new RMServerSequence(rmCreateSequence.getOffer().getIdentifier()) : new RMServerSequence();
            SOAPAddressingProperties clientInboundAddrProps = (SOAPAddressingProperties)msgContext.get("javax.xml.ws.addressing.context.inbound");
            if (clientInboundAddrProps != null && clientInboundAddrProps.getTo() != null) {
                sequence.setAcksTo(clientInboundAddrProps.getTo().getURI());
            }
            RMStore.serialize(dataDir, sequence);
            protocolMessages.add(rmConstants.getCreateSequenceResponseQName());
            rmResponseContext.put("wsrm.sequenceReference", sequence);
            isOneWayOperation = false;
        }
        if (RMHelper.isCloseSequence(rmReqProps)) {
            data = (Map)rmReqProps.get("wsrm.protocolMessagesMapping");
            payload = (RMCloseSequence)data.get(rmConstants.getCloseSequenceQName());
            seqIdentifier = payload.getIdentifier();
            sequence = RMStore.deserialize(dataDir, seqIdentifier, true);
            if (sequence == null) {
                throw RMInvocationHandler.getUnknownSequenceFault(seqIdentifier);
            }
            sequence.close();
            RMStore.serialize(dataDir, sequence);
            protocolMessages.add(rmConstants.getCloseSequenceResponseQName());
            protocolMessages.add(rmConstants.getSequenceAcknowledgementQName());
            rmResponseContext.put("wsrm.sequenceReference", sequence);
            isOneWayOperation = false;
        }
        if (RMHelper.isSequenceAcknowledgement(rmReqProps)) {
            data = (Map)rmReqProps.get("wsrm.protocolMessagesMapping");
            payload = (RMSequenceAcknowledgement)data.get(rmConstants.getSequenceAcknowledgementQName());
            seqIdentifier = payload.getIdentifier();
            sequence = RMStore.deserialize(dataDir, seqIdentifier, false);
            if (sequence == null) {
                throw RMInvocationHandler.getUnknownSequenceFault(seqIdentifier);
            }
            for (RMSequenceAcknowledgement.RMAcknowledgementRange range : payload.getAcknowledgementRanges()) {
                for (long i = range.getLower(); i <= range.getUpper(); ++i) {
                    if (i > sequence.getLastMessageNumber()) {
                        RMStore.serialize(dataDir, sequence);
                        HashMap<String, RMSequenceAcknowledgement.RMAcknowledgementRange> detailsMap = new HashMap<String, RMSequenceAcknowledgement.RMAcknowledgementRange>(2);
                        detailsMap.put("acknowledgement", range);
                        throw new RMFault(RMFaultCode.INVALID_ACKNOWLEDGEMENT, new HashMap<String, Object>(2));
                    }
                    sequence.addReceivedOutboundMessage(i);
                }
            }
            RMStore.serialize(dataDir, sequence);
        }
        if (RMHelper.isTerminateSequence(rmReqProps)) {
            data = (Map)rmReqProps.get("wsrm.protocolMessagesMapping");
            payload = (RMTerminateSequence)data.get(rmConstants.getTerminateSequenceQName());
            seqIdentifier = payload.getIdentifier();
            sequence = RMStore.deserialize(dataDir, seqIdentifier, true);
            if (sequence == null) {
                throw RMInvocationHandler.getUnknownSequenceFault(seqIdentifier);
            }
            RMStore.serialize(dataDir, sequence);
            if (RMProvider.get().getMessageFactory().newTerminateSequenceResponse() != null) {
                protocolMessages.add(rmConstants.getTerminateSequenceResponseQName());
                protocolMessages.add(rmConstants.getSequenceAcknowledgementQName());
                rmResponseContext.put("wsrm.sequenceReference", sequence);
                isOneWayOperation = false;
            } else {
                return null;
            }
        }
        if (RMHelper.isSequence(rmReqProps)) {
            boolean retTypeIsVoid;
            data = (Map)rmReqProps.get("wsrm.protocolMessagesMapping");
            payload = (RMSequence)data.get(rmConstants.getSequenceQName());
            seqIdentifier = payload.getIdentifier();
            sequence = RMStore.deserialize(dataDir, seqIdentifier, true);
            if (sequence == null) {
                throw RMInvocationHandler.getUnknownSequenceFault(seqIdentifier);
            }
            try {
                sequence.addReceivedInboundMessage(payload.getMessageNumber());
            }
            finally {
                RMStore.serialize(dataDir, sequence);
            }
            protocolMessages.add(rmConstants.getSequenceAcknowledgementQName());
            rmResponseContext.put("wsrm.sequenceReference", sequence);
            boolean bl = retTypeIsVoid = inv.getJavaMethod().getReturnType().equals(Void.class) || inv.getJavaMethod().getReturnType().equals(Void.TYPE);
            if (!retTypeIsVoid) {
                try {
                    sequence.newMessageNumber();
                }
                finally {
                    RMStore.serialize(dataDir, sequence);
                }
                protocolMessages.add(rmConstants.getSequenceQName());
                protocolMessages.add(rmConstants.getAckRequestedQName());
            } else {
                AddressingBuilder builder = AddressingBuilder.getAddressingBuilder();
                AddressingProperties addressingProps = builder.newAddressingProperties();
                addressingProps.setTo(builder.newURI(addrProps.getReplyTo().getAddress().getURI()));
                addressingProps.setRelatesTo(new Relationship[]{builder.newRelationship(addrProps.getMessageID().getURI())});
                try {
                    addressingProps.setAction(builder.newURI(RMAddressingConstants.SEQUENCE_ACKNOWLEDGEMENT_WSA_ACTION));
                }
                catch (URISyntaxException ignore) {
                    // empty catch block
                }
                rmResponseContext.put("javax.xml.ws.addressing.context.outbound", addressingProps);
            }
            isOneWayOperation = false;
        }
        rmResponseContext.put("wsrm.oneWayOperation", isOneWayOperation);
        return rmResponseContext;
    }

    private static RMFault getUnknownSequenceFault(String sequenceId) {
        HashMap<String, Object> detailsMap = new HashMap<String, Object>(2);
        detailsMap.put("identifier", sequenceId);
        return new RMFault(RMFaultCode.UNKNOWN_SEQUENCE, detailsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invoke(Endpoint ep, Invocation inv) throws Exception {
        Map<String, Object> rmResponseContext = null;
        try {
            rmResponseContext = RMInvocationHandler.prepareResponseContext(ep, inv, this.dataDir);
        }
        catch (RMFault fault) {
            rmResponseContext = new HashMap<String, Object>();
            LinkedList<QName> protocolMessages = new LinkedList<QName>();
            protocolMessages.add(rmConstants.getSequenceFaultQName());
            rmResponseContext.put("wsrm.protocolMessages", protocolMessages);
            rmResponseContext.put("wsrm.faultReference", (Object)fault);
            rmResponseContext.put("wsrm.oneWayOperation", false);
            CommonMessageContext msgCtx = MessageContextAssociation.peekMessageContext();
            msgCtx.put("wsrm.responseContext", (Object)rmResponseContext);
            throw fault;
        }
        try {
            if (inv.getJavaMethod() != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Invoking method: " + inv.getJavaMethod().getName()));
                }
                this.delegate.invoke(ep, inv);
            } else {
                logger.debug((Object)"RM lifecycle protocol method detected");
            }
        }
        finally {
            this.setupResponseContext(rmResponseContext);
        }
    }

    private void setupResponseContext(Map<String, Object> rmResponseContext) {
        if (rmResponseContext != null) {
            CommonMessageContext msgCtx = MessageContextAssociation.peekMessageContext();
            msgCtx.put("wsrm.responseContext", (Object)rmResponseContext);
            msgCtx.put("javax.xml.ws.addressing.context.outbound", rmResponseContext.get("javax.xml.ws.addressing.context.outbound"));
        }
    }

    public final InvocationHandler getDelegate() {
        return this.delegate;
    }

    public Context getJNDIContext(Endpoint ep) throws NamingException {
        return this.delegate.getJNDIContext(ep);
    }
}

