/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.cluster.impl;

import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.cluster.DiscoveryEntry;
import org.hornetq.core.cluster.DiscoveryGroup;
import org.hornetq.core.cluster.DiscoveryListener;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.server.management.NotificationService;
import org.hornetq.utils.TypedProperties;

public class DiscoveryGroupImpl
implements Runnable,
DiscoveryGroup {
    private static final Logger log = Logger.getLogger(DiscoveryGroupImpl.class);
    private static final int SOCKET_TIMEOUT = 500;
    private MulticastSocket socket;
    private final List<DiscoveryListener> listeners = new ArrayList<DiscoveryListener>();
    private final String name;
    private Thread thread;
    private boolean received;
    private final Object waitLock = new Object();
    private final Map<String, DiscoveryEntry> connectors = new HashMap<String, DiscoveryEntry>();
    private final long timeout;
    private volatile boolean started;
    private final String nodeID;
    private final InetAddress localBindAddress;
    private final InetAddress groupAddress;
    private final int groupPort;
    private final Map<String, String> uniqueIDMap = new HashMap<String, String>();
    private NotificationService notificationService;

    public DiscoveryGroupImpl(String nodeID, String name, InetAddress localBindAddress, InetAddress groupAddress, int groupPort, long timeout) throws Exception {
        this.nodeID = nodeID;
        this.name = name;
        this.timeout = timeout;
        this.localBindAddress = localBindAddress;
        this.groupAddress = groupAddress;
        this.groupPort = groupPort;
    }

    @Override
    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.socket = new MulticastSocket(this.groupPort);
        if (this.localBindAddress != null) {
            this.socket.setInterface(this.localBindAddress);
        }
        this.socket.joinGroup(this.groupAddress);
        this.socket.setSoTimeout(500);
        this.started = true;
        this.thread = new Thread((Runnable)this, "hornetq-discovery-group-thread-" + this.name);
        this.thread.setDaemon(true);
        this.thread.start();
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), new SimpleString(this.name));
            Notification notification = new Notification(this.nodeID, NotificationType.DISCOVERY_GROUP_STARTED, props);
            this.notificationService.sendNotification(notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        DiscoveryGroupImpl discoveryGroupImpl = this;
        synchronized (discoveryGroupImpl) {
            if (!this.started) {
                return;
            }
            this.started = false;
        }
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.socket.close();
        this.socket = null;
        this.thread = null;
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), new SimpleString(this.name));
            Notification notification = new Notification(this.nodeID, NotificationType.DISCOVERY_GROUP_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                log.warn("unable to send notification when discovery group is stopped", e);
            }
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized Map<String, DiscoveryEntry> getDiscoveryEntryMap() {
        return new HashMap<String, DiscoveryEntry>(this.connectors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForBroadcast(long timeout) {
        Object object = this.waitLock;
        synchronized (object) {
            long now;
            long start = System.currentTimeMillis();
            for (long toWait = timeout; !this.received && toWait > 0L; toWait -= now - start) {
                try {
                    this.waitLock.wait(toWait);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                now = System.currentTimeMillis();
                start = now;
            }
            boolean ret = this.received;
            this.received = false;
            return ret;
        }
    }

    private void checkUniqueID(String originatingNodeID, String uniqueID) {
        String currentUniqueID = this.uniqueIDMap.get(originatingNodeID);
        if (currentUniqueID == null) {
            this.uniqueIDMap.put(originatingNodeID, uniqueID);
        } else if (!currentUniqueID.equals(uniqueID)) {
            log.warn("There are more than one servers on the network broadcasting the same node id. You will see this message exactly once (per node) if a node is restarted, in which case it can be safely ignored. But if it is logged continuously it means you really do have more than one node on the same network active concurrently with the same node id. This could occur if you have a backup node active at the same time as its live node.");
            this.uniqueIDMap.put(originatingNodeID, uniqueID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            byte[] data = new byte[65535];
            while (true) {
                if (!this.started) {
                    return;
                }
                DatagramPacket packet = new DatagramPacket(data, data.length);
                try {
                    this.socket.receive(packet);
                }
                catch (InterruptedIOException e) {
                    if (this.started) continue;
                    return;
                }
                HornetQBuffer buffer = HornetQBuffers.wrappedBuffer(data);
                String originatingNodeID = buffer.readString();
                String uniqueID = buffer.readString();
                this.checkUniqueID(originatingNodeID, uniqueID);
                if (this.nodeID.equals(originatingNodeID)) continue;
                int size = buffer.readInt();
                boolean changed = false;
                Object object = this;
                // MONITORENTER : object
                for (int i = 0; i < size; ++i) {
                    Pair<TransportConfiguration, TransportConfiguration> connectorPair;
                    DiscoveryEntry entry;
                    DiscoveryEntry oldVal;
                    TransportConfiguration connector = new TransportConfiguration();
                    connector.decode(buffer);
                    boolean existsBackup = buffer.readBoolean();
                    TransportConfiguration backupConnector = null;
                    if (existsBackup) {
                        backupConnector = new TransportConfiguration();
                        backupConnector.decode(buffer);
                    }
                    if ((oldVal = this.connectors.put(originatingNodeID, entry = new DiscoveryEntry(connectorPair = new Pair<TransportConfiguration, TransportConfiguration>(connector, backupConnector), System.currentTimeMillis()))) != null) continue;
                    changed = true;
                }
                long now = System.currentTimeMillis();
                Iterator<Map.Entry<String, DiscoveryEntry>> iter = this.connectors.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<String, DiscoveryEntry> entry = iter.next();
                    if (entry.getValue().getLastUpdate() + this.timeout > now) continue;
                    iter.remove();
                    changed = true;
                }
                // MONITOREXIT : object
                if (changed) {
                    this.callListeners();
                }
                object = this.waitLock;
                // MONITORENTER : object
                this.received = true;
                this.waitLock.notify();
                // MONITOREXIT : object
            }
        }
        catch (Exception e) {
            log.error("Failed to receive datagram", e);
            return;
        }
    }

    @Override
    public synchronized void registerListener(DiscoveryListener listener) {
        this.listeners.add(listener);
        if (!this.connectors.isEmpty()) {
            listener.connectorsChanged();
        }
    }

    @Override
    public synchronized void unregisterListener(DiscoveryListener listener) {
        this.listeners.remove(listener);
    }

    private void callListeners() {
        for (DiscoveryListener listener : this.listeners) {
            try {
                listener.connectorsChanged();
            }
            catch (Throwable t) {
                log.error("Failed to call discovery listener", t);
            }
        }
    }
}

