/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.jca;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.resource.ResourceException;
import javax.servlet.ServletException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.resource.connectionmanager.CachedConnectionManager;
import org.jboss.servlet.http.HttpEvent;

public class CachedConnectionValve
extends ValveBase
implements Lifecycle {
    private static final Logger log = Logger.getLogger(CachedConnectionValve.class);
    private static final String info = "CachedConnectionValve/1.0";
    protected LifecycleSupport support = new LifecycleSupport((Lifecycle)this);
    protected String ccmName;
    protected CachedConnectionManager ccm;
    protected String tmName;
    protected TransactionManager tm;
    protected Set unsharableResources = new HashSet();

    public String getInfo() {
        return info;
    }

    public String getCachedConnectionManagerObjectName() {
        return this.ccmName;
    }

    public void setCachedConnectionManagerObjectName(String ccmName) {
        this.ccmName = ccmName;
    }

    public String getTransactionManagerObjectName() {
        return this.tmName;
    }

    public void setTransactionManagerObjectName(String tmName) {
        this.tmName = tmName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.ccm == null) {
            throw new IllegalStateException("Uncomment the dependency on CachedConnectionManager in META-INF/jboss-service.xml of jbossweb-tomcatxxx.sar");
        }
        try {
            this.ccm.pushMetaAwareObject((Object)this, this.unsharableResources);
            try {
                this.getNext().invoke(request, response);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    this.ccm.popMetaAwareObject(this.unsharableResources);
                    Object var6_7 = null;
                    this.checkTransactionComplete(request);
                }
                catch (Throwable throwable2) {
                    Object var6_8 = null;
                    this.checkTransactionComplete(request);
                    throw throwable2;
                }
                throw throwable;
            }
            try {
                this.ccm.popMetaAwareObject(this.unsharableResources);
                Object var6_5 = null;
                this.checkTransactionComplete(request);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.checkTransactionComplete(request);
                throw throwable;
            }
        }
        catch (ResourceException e) {
            throw new ServletException("Error invoking cached connection manager", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(Request request, Response response, HttpEvent event) throws IOException, ServletException {
        try {
            Object v1;
            this.ccm.pushMetaAwareObject((Object)this, this.unsharableResources);
            try {
                this.getNext().event(request, response, event);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var5_5 = null;
                try {
                    this.ccm.popMetaAwareObject(this.unsharableResources);
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var7_9 = v0;
                this.checkTransactionComplete(request);
                throw throwable;
            }
            try {
                this.ccm.popMetaAwareObject(this.unsharableResources);
                v1 = null;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            Object var7_8 = v1;
            this.checkTransactionComplete(request);
            {
            }
        }
        catch (ResourceException e) {
            throw new ServletException("Error invoking cached connection manager", (Throwable)e);
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.support.addLifecycleListener(listener);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.support.removeLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.support.findLifecycleListeners();
    }

    public void start() throws LifecycleException {
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            this.ccm = (CachedConnectionManager)server.getAttribute(new ObjectName(this.ccmName), "Instance");
            this.tm = (TransactionManager)server.getAttribute(new ObjectName(this.tmName), "TransactionManager");
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e);
        }
        this.support.fireLifecycleEvent("start", (Object)this);
    }

    public void stop() throws LifecycleException {
        this.support.fireLifecycleEvent("stop", (Object)this);
        this.unsharableResources.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTransactionComplete(Request request) {
        block24: {
            int status = 6;
            try {
                status = this.tm.getStatus();
            }
            catch (SystemException ex) {
                log.error((Object)"Failed to get status", (Throwable)ex);
            }
            try {
                switch (status) {
                    case 0: 
                    case 1: 
                    case 7: 
                    case 8: 
                    case 9: {
                        try {
                            this.tm.rollback();
                        }
                        catch (Exception ex) {
                            log.error((Object)"Failed to rollback", (Throwable)ex);
                        }
                    }
                    case 2: {
                        String servletName = "<Unknown>";
                        try {
                            Wrapper servlet = request.getWrapper();
                            if (servlet != null) {
                                servletName = servlet.getName();
                                if (servlet.getJspFile() != null) {
                                    servletName = servlet.getJspFile();
                                }
                            }
                        }
                        catch (Throwable ignored) {
                            // empty catch block
                        }
                        String msg = "Application error: " + servletName + " did not complete its transaction";
                        log.error((Object)msg);
                    }
                }
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                block26: {
                    Object var6_9 = null;
                    try {
                        Transaction tx = this.tm.suspend();
                        if (tx == null) break block26;
                        String servletName = "<Unknown>";
                        try {
                            Wrapper servlet = request.getWrapper();
                            if (servlet != null) {
                                servletName = servlet.getName();
                                if (servlet.getJspFile() != null) {
                                    servletName = servlet.getJspFile();
                                }
                            }
                        }
                        catch (Throwable ignored) {
                            // empty catch block
                        }
                        String msg = "Application error: " + servletName + " did not complete its transaction suspended tx=" + tx;
                        log.error((Object)msg);
                    }
                    catch (SystemException ex) {
                        log.error((Object)"Failed to suspend transaction", (Throwable)ex);
                    }
                }
                throw throwable;
            }
            try {
                Transaction tx = this.tm.suspend();
                if (tx == null) break block24;
                String servletName = "<Unknown>";
                try {
                    Wrapper servlet = request.getWrapper();
                    if (servlet != null) {
                        servletName = servlet.getName();
                        if (servlet.getJspFile() != null) {
                            servletName = servlet.getJspFile();
                        }
                    }
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                String msg = "Application error: " + servletName + " did not complete its transaction suspended tx=" + tx;
                log.error((Object)msg);
            }
            catch (SystemException ex) {
                log.error((Object)"Failed to suspend transaction", (Throwable)ex);
            }
        }
    }
}

