/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.remoting3.remote.AbstractMessageHandler;
import org.jboss.remoting3.remote.Loggers;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.RemoteMessageHandler;
import org.jboss.remoting3.remote.ServerInitialAuthenticationHandler;
import org.jboss.remoting3.spi.ConnectionHandler;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.remoting3.spi.SpiUtils;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.log.Logger;

final class ServerAuthenticationHandler
extends AbstractMessageHandler {
    private final RemoteConnection remoteConnection;
    private final SaslServer saslServer;
    private final ConnectionProviderContext connectionProviderContext;
    private final ServerInitialAuthenticationHandler initialAuthHandler;
    private static final Logger log = Loggers.serverSasl;

    ServerAuthenticationHandler(RemoteConnection remoteConnection, SaslServer saslServer, ConnectionProviderContext connectionProviderContext, ServerInitialAuthenticationHandler initialAuthHandler) {
        super(remoteConnection);
        this.saslServer = saslServer;
        this.remoteConnection = remoteConnection;
        this.connectionProviderContext = connectionProviderContext;
        this.initialAuthHandler = initialAuthHandler;
    }

    public void handleMessage(ByteBuffer buffer) {
        switch (buffer.get()) {
            case 3: {
                log.trace("Received SASL response");
                try {
                    byte[] challenge;
                    try {
                        challenge = this.saslServer.evaluateResponse(Buffers.take((ByteBuffer)buffer, (int)buffer.remaining()));
                    }
                    catch (SaslException e) {
                        log.trace((Throwable)e, "Server authentication failed", new Object[0]);
                        this.initialAuthHandler.rejectAuth();
                        this.remoteConnection.setMessageHandler(this.initialAuthHandler);
                        return;
                    }
                    boolean complete = this.saslServer.isComplete();
                    if (complete) {
                        log.trace("Sending SASL complete");
                        this.remoteConnection.sendAuthMessage((byte)4, challenge);
                        this.connectionProviderContext.accept(new ConnectionHandlerFactory(){

                            public ConnectionHandler createInstance(ConnectionHandlerContext connectionContext) {
                                MarshallerFactory marshallerFactory = ServerAuthenticationHandler.this.remoteConnection.getProviderDescriptor().getMarshallerFactory();
                                RemoteConnectionHandler connectionHandler = new RemoteConnectionHandler(connectionContext, ServerAuthenticationHandler.this.remoteConnection, marshallerFactory);
                                ServerAuthenticationHandler.this.remoteConnection.addCloseHandler(SpiUtils.closingCloseHandler(connectionHandler));
                                ServerAuthenticationHandler.this.remoteConnection.setMessageHandler(new RemoteMessageHandler(connectionHandler, ServerAuthenticationHandler.this.remoteConnection));
                                return connectionHandler;
                            }
                        });
                        break;
                    }
                    log.trace("Sending subsequent SASL challenge");
                    this.remoteConnection.sendAuthMessage((byte)2, challenge);
                }
                catch (IOException e) {
                    log.trace((Throwable)e, "Failed to send auth message", new Object[0]);
                    IoUtils.safeClose((Closeable)this.remoteConnection);
                }
                break;
            }
            default: {
                log.warn("Server received invalid message on %s", (Object)this.remoteConnection);
                IoUtils.safeClose((Closeable)this.remoteConnection);
            }
        }
    }
}

