/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.bundle;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.bundle.BundleAgentService;
import org.rhq.core.clientapi.agent.bundle.BundleScheduleRequest;
import org.rhq.core.clientapi.agent.bundle.BundleScheduleResponse;
import org.rhq.core.clientapi.server.bundle.BundleServerService;
import org.rhq.core.domain.bundle.BundleDeployDefinition;
import org.rhq.core.domain.bundle.BundleType;
import org.rhq.core.domain.bundle.BundleVersion;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.ContainerService;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.agent.AgentService;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.util.ComponentUtil;
import org.rhq.core.pc.util.FacetLockType;
import org.rhq.core.pluginapi.bundle.BundleDeployRequest;
import org.rhq.core.pluginapi.bundle.BundleDeployResult;
import org.rhq.core.pluginapi.bundle.BundleFacet;
import org.rhq.core.pluginapi.bundle.BundleManagerProvider;
import org.rhq.core.util.MessageDigestGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleManager
extends AgentService
implements BundleAgentService,
BundleManagerProvider,
ContainerService {
    private final Log log = LogFactory.getLog(BundleManager.class);
    private PluginContainerConfiguration configuration;

    public BundleManager() {
        super(BundleAgentService.class);
    }

    @Override
    public void setConfiguration(PluginContainerConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void shutdown() {
    }

    public List<PackageVersion> getAllBundleVersionPackageVersions(BundleVersion bundleVersion) throws Exception {
        int bvId = bundleVersion.getId();
        List pvs = this.getBundleServerService().getAllBundleVersionPackageVersions(bvId);
        return pvs;
    }

    public long getFileContent(PackageVersion packageVersion, OutputStream outputStream) throws Exception {
        long size = this.getBundleServerService().downloadPackageBits(packageVersion, outputStream);
        return size;
    }

    public BundleScheduleResponse schedule(BundleScheduleRequest request) {
        BundleScheduleResponse response = new BundleScheduleResponse();
        try {
            BundleDeployDefinition bundleDeployDef = request.getBundleDeployDefinition();
            InventoryManager im = PluginContainer.getInstance().getInventoryManager();
            BundleType bundleType = bundleDeployDef.getBundleVersion().getBundle().getBundleType();
            ResourceType resourceType = bundleType.getResourceType();
            Set<Resource> resources = im.getResourcesWithType(resourceType);
            if (resources.isEmpty()) {
                throw new Exception("No bundle plugin supports bundle type [" + bundleType + "]");
            }
            int bundleHandlerResourceId = resources.iterator().next().getId();
            ResourceContainer resourceContainer = im.getResourceContainer(bundleHandlerResourceId);
            File pluginTmpDir = resourceContainer.getResourceContext().getTemporaryDirectory();
            File bundleFilesDir = new File(pluginTmpDir, "" + bundleDeployDef.getBundleVersion().getId());
            Map<PackageVersion, File> downloadedFiles = this.downloadBundleFiles(bundleDeployDef, bundleFilesDir);
            int facetMethodTimeout = 14400000;
            BundleFacet bundlePluginComponent = this.getBundleFacet(bundleHandlerResourceId, facetMethodTimeout);
            BundleDeployRequest deployRequest = new BundleDeployRequest();
            deployRequest.setBundleManagerProvider((BundleManagerProvider)this);
            deployRequest.setBundleDeployDefinition(request.getBundleDeployDefinition());
            deployRequest.setBundleFilesLocation(bundleFilesDir);
            deployRequest.setPackageVersionFiles(downloadedFiles);
            BundleDeployResult result = bundlePluginComponent.deployBundle(deployRequest);
            if (!result.isSuccess()) {
                response.setErrorMessage(result.getErrorMessage());
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to schedule bundle request: " + request), t);
            response.setErrorMessage(t);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<PackageVersion, File> downloadBundleFiles(BundleDeployDefinition bundleDeployDef, File downloadDir) throws Exception {
        BundleVersion bundleVersion = bundleDeployDef.getBundleVersion();
        HashMap<PackageVersion, File> packageVersionFiles = new HashMap<PackageVersion, File>();
        List<PackageVersion> packageVersions = this.getAllBundleVersionPackageVersions(bundleVersion);
        for (PackageVersion packageVersion : packageVersions) {
            File packageFile = new File(downloadDir, packageVersion.getFileName());
            try {
                this.verifyHash(packageVersion, packageFile);
            }
            catch (Exception e) {
                packageFile.getParentFile().mkdirs();
                FileOutputStream fos = new FileOutputStream(packageFile);
                try {
                    long size = this.getFileContent(packageVersion, fos);
                    if (packageVersion.getFileSize() != null && size != packageVersion.getFileSize()) {
                        this.log.warn((Object)("Downloaded bundle file [" + packageVersion + "] but its size was [" + size + "] when it was expected to be [" + packageVersion.getFileSize() + "]."));
                    }
                }
                finally {
                    fos.close();
                }
                this.verifyHash(packageVersion, packageFile);
            }
            packageVersionFiles.put(packageVersion, packageFile);
        }
        return packageVersionFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyHash(PackageVersion packageVersion, File packageFile) throws Exception {
        block9: {
            if (!packageFile.exists()) {
                throw new Exception("Package version [" + packageVersion + "] does not exist, cannot check hash");
            }
            if (packageVersion.getMD5() != null) {
                String realMD5 = MessageDigestGenerator.getDigestString((File)packageFile);
                if (!packageVersion.getMD5().equals(realMD5)) {
                    throw new Exception("Package version [" + packageVersion + "] failed MD5 check. expected=[" + packageVersion.getMD5() + "], actual=[" + realMD5 + "]");
                }
            } else {
                if (packageVersion.getSHA256() != null) {
                    FileInputStream is = new FileInputStream(packageFile);
                    try {
                        MessageDigestGenerator gen = new MessageDigestGenerator("SHA256");
                        gen.add((InputStream)is);
                        String realSHA256 = gen.getDigestString();
                        if (!packageVersion.getSHA256().equals(realSHA256)) {
                            throw new Exception("Package version [" + packageVersion + "] failed SHA256 check. expected=[" + packageVersion.getSHA256() + "], actual=[" + realSHA256 + "]");
                        }
                        break block9;
                    }
                    finally {
                        is.close();
                    }
                }
                this.log.debug((Object)("Package version [" + packageVersion + "] has no MD5/SHA256 hash - not verifying it"));
            }
        }
    }

    private BundleServerService getBundleServerService() {
        if (this.configuration.getServerServices() != null) {
            return this.configuration.getServerServices().getBundleServerService();
        }
        throw new IllegalStateException("There is no bundle server service available to obtain bundle files");
    }

    private BundleFacet getBundleFacet(int resourceId, long timeout) throws PluginContainerException {
        return ComponentUtil.getComponent(resourceId, BundleFacet.class, FacetLockType.READ, timeout, false, true);
    }
}

