/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.plugin;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.metadata.PluginMetadataManager;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.plugin.PluginEnvironment;
import org.rhq.core.pc.plugin.PluginFinder;
import org.rhq.core.pc.plugin.PluginManager;
import org.rhq.core.pc.plugin.SimplePluginFinder;
import org.rhq.core.pluginapi.bundle.BundleFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.plugin.PluginLifecycleListener;

public class PluginValidator {
    private static final Log LOG = LogFactory.getLog(PluginValidator.class);
    private static final String PLUGIN_DESCRIPTOR_PATH = "META-INF/rhq-plugin.xml";

    public static void main(String[] args) {
        SimplePluginFinder finder;
        try {
            if (args.length > 0) {
                finder = new SimplePluginFinder();
                for (String arg : args) {
                    URL jarUrl = new File(arg).toURI().toURL();
                    finder.addUrl(jarUrl);
                    LOG.info((Object)("Plugin jar: " + jarUrl));
                }
            } else {
                finder = PluginValidator.findPluginJars();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (PluginValidator.validatePlugins(finder)) {
            System.out.println("!OK!");
            System.exit(0);
        } else {
            System.out.println("!FAILED!");
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validatePlugins(PluginFinder finder) {
        PluginContainerConfiguration configuration = new PluginContainerConfiguration();
        configuration.setPluginFinder(finder);
        configuration.setTemporaryDirectory(new File(System.getProperty("java.io.tmpdir")));
        PluginManager manager = new PluginManager();
        manager.setConfiguration(configuration);
        manager.initialize();
        boolean success = true;
        try {
            boolean sizesMatch;
            boolean bl = sizesMatch = manager.getPlugins().size() == finder.findPlugins().size();
            if (!sizesMatch) {
                success = false;
                LOG.error((Object)("Only [" + manager.getPlugins().size() + "] out of [" + finder.findPlugins().size() + "] plugin descriptors are valid."));
            } else {
                LOG.info((Object)("All [" + finder.findPlugins().size() + "] plugin descriptors are valid."));
            }
            PluginMetadataManager metadataManager = manager.getMetadataManager();
            for (ResourceType resourceType : metadataManager.getAllTypes()) {
                PluginEnvironment pluginEnvironment = manager.getPlugin(resourceType.getPlugin());
                LOG.info((Object)("Validating resource type [" + resourceType.getName() + "] from plugin [" + resourceType.getPlugin() + "]..."));
                success = success && PluginValidator.validateResourceComponentClass(metadataManager, resourceType, pluginEnvironment);
                success = success && PluginValidator.validateResourceDiscoveryComponentClass(metadataManager, resourceType, pluginEnvironment);
                success = success && PluginValidator.validatePluginLifecycleListenerClass(metadataManager, resourceType, pluginEnvironment);
            }
        }
        finally {
            manager.shutdown();
        }
        return success;
    }

    private static boolean validateResourceComponentClass(PluginMetadataManager metadataManager, ResourceType resourceType, PluginEnvironment pluginEnvironment) {
        boolean success = true;
        String componentClass = metadataManager.getComponentClass(resourceType);
        if (componentClass == null) {
            success = false;
            LOG.error((Object)("Missing component class in resource type [" + resourceType.getName() + "] from plugin [" + resourceType.getPlugin() + "]"));
        } else {
            try {
                Class<?> componentClazz = Class.forName(componentClass, false, pluginEnvironment.getPluginClassLoader());
                if (!ResourceComponent.class.isAssignableFrom(componentClazz)) {
                    success = false;
                    LOG.error((Object)("Component class [" + componentClass + "] for resource type [" + resourceType.getName() + "] from plugin [" + resourceType.getPlugin() + "] does not implement " + ResourceComponent.class));
                }
                if (!resourceType.getMetricDefinitions().isEmpty() && !MeasurementFacet.class.isAssignableFrom(componentClazz)) {
                    success = false;
                    LOG.error((Object)("Component class [" + componentClass + "] for resource type [" + resourceType.getName() + "] from plugin [" + resourceType.getPlugin() + "] does not support the measurement collection facet but defines metrics."));
                }
                if (!resourceType.getOperationDefinitions().isEmpty() && !OperationFacet.class.isAssignableFrom(componentClazz)) {
                    success = false;
                    LOG.error((Object)("Component class [" + componentClass + "] for resource type [" + resourceType.getName() + "] from plugin [" + resourceType.getPlugin() + "] does not support the operations facet but defines operations."));
                }
                if (resourceType.getBundleType() != null && !BundleFacet.class.isAssignableFrom(componentClazz)) {
                    success = false;
                    LOG.error((Object)("Component class [" + componentClass + "] for resource type [" + resourceType.getName() + "] from plugin [" + resourceType.getPlugin() + "] does not support the bundle facet but defines a bundle type."));
                }
                if (!(resourceType.getPackageTypes().isEmpty() || ContentFacet.class.isAssignableFrom(componentClazz) || resourceType.getBundleType() != null && resourceType.getPackageTypes().size() == 1 && resourceType.getBundleType().getName().equals(((PackageType)resourceType.getPackageTypes().iterator().next()).getName()))) {
                    success = false;
                    LOG.error((Object)("Component class [" + componentClass + "] for resource type [" + resourceType.getName() + "] from plugin [" + resourceType.getPlugin() + "] does not support the content management facet but defines package types."));
                }
                if (resourceType.getResourceConfigurationDefinition() != null && !ConfigurationFacet.class.isAssignableFrom(componentClazz)) {
                    success = false;
                    LOG.error((Object)("Component class [" + componentClass + "] for resource type [" + resourceType.getName() + "] from plugin [" + resourceType.getPlugin() + "] does not support the configuration facet but defines resource configuration."));
                }
                boolean hasCreatableChild = false;
                for (ResourceType childResourceType : resourceType.getChildResourceTypes()) {
                    if (!childResourceType.isCreatable()) continue;
                    hasCreatableChild = true;
                    break;
                }
                if (hasCreatableChild && !CreateChildResourceFacet.class.isAssignableFrom(componentClazz)) {
                    success = false;
                    LOG.error((Object)("Component class [" + componentClass + "] for resource type [" + resourceType.getName() + "] from plugin [" + resourceType.getPlugin() + "] does not support the child creation facet but has metadata saying it can."));
                }
                if (resourceType.isDeletable() && !DeleteResourceFacet.class.isAssignableFrom(componentClazz)) {
                    success = false;
                    LOG.error((Object)("Component class [" + componentClass + "] for resource type [" + resourceType.getName() + "] from plugin [" + resourceType.getPlugin() + "] does not support delete resource facet but has metadata saying it can delete children."));
                }
            }
            catch (Exception e) {
                success = false;
                LOG.error((Object)("Cannot find component class [" + componentClass + "] for resource type [" + resourceType.getName() + "] from plugin [" + resourceType.getPlugin() + "]."));
            }
        }
        return success;
    }

    private static boolean validateResourceDiscoveryComponentClass(PluginMetadataManager metadataManager, ResourceType resourceType, PluginEnvironment pluginEnvironment) {
        boolean success = true;
        String discoveryClass = metadataManager.getDiscoveryClass(resourceType);
        if (discoveryClass != null) {
            try {
                Class<?> discoveryClazz = Class.forName(discoveryClass, false, pluginEnvironment.getPluginClassLoader());
                if (!ResourceDiscoveryComponent.class.isAssignableFrom(discoveryClazz)) {
                    success = false;
                    LOG.error((Object)("Discovery class [" + discoveryClass + "] for resource type [" + resourceType.getName() + "] from plugin [" + resourceType.getPlugin() + "] does not implement " + ResourceDiscoveryComponent.class));
                }
                if (resourceType.isSupportsManualAdd() && !ManualAddFacet.class.isAssignableFrom(discoveryClazz)) {
                    LOG.warn((Object)("Discovery class [" + discoveryClass + "] for resource type [" + resourceType.getName() + "] from plugin [" + resourceType.getPlugin() + "] does not implement " + ManualAddFacet.class + " - implementing manual-add in discoverResources() is deprecated."));
                }
            }
            catch (Exception e) {
                success = false;
                LOG.error((Object)("Cannot find discovery class [" + discoveryClass + "] for resource type [" + resourceType.getName() + "] from plugin [" + resourceType.getPlugin() + "]."));
            }
        }
        return success;
    }

    private static boolean validatePluginLifecycleListenerClass(PluginMetadataManager metadataManager, ResourceType resourceType, PluginEnvironment pluginEnvironment) {
        boolean success = true;
        String overseerClass = metadataManager.getPluginLifecycleListenerClass(resourceType.getPlugin());
        if (overseerClass != null) {
            try {
                Class<?> overseerClazz = Class.forName(overseerClass, false, pluginEnvironment.getPluginClassLoader());
                if (!PluginLifecycleListener.class.isAssignableFrom(overseerClazz)) {
                    success = false;
                    LOG.error((Object)("Plugin Lifecycle Listener class [" + overseerClass + "] for plugin [" + resourceType.getPlugin() + "] does not implement " + PluginLifecycleListener.class));
                }
            }
            catch (Exception e) {
                success = false;
                LOG.error((Object)("Cannot find Plugin Lifecycle Listener class [" + overseerClass + "] for plugin [" + resourceType.getPlugin() + "]."));
            }
        }
        return success;
    }

    private static SimplePluginFinder findPluginJars() throws Exception {
        SimplePluginFinder pluginFinder = new SimplePluginFinder();
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> descriptorUrls = classloader.getResources(PLUGIN_DESCRIPTOR_PATH);
        while (descriptorUrls.hasMoreElements()) {
            URL descriptorUrl = descriptorUrls.nextElement();
            URLConnection connection = descriptorUrl.openConnection();
            if (connection instanceof JarURLConnection) {
                URL jarUrl = ((JarURLConnection)connection).getJarFileURL();
                pluginFinder.addUrl(jarUrl);
                LOG.info((Object)("Found plugin jar: " + jarUrl));
                continue;
            }
            LOG.warn((Object)("Found a plugin descriptor outside of a jar, skipping: " + descriptorUrl));
        }
        return pluginFinder;
    }
}

