/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.invm;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.remoting.impl.invm.InVMAcceptorFactory;
import org.hornetq.core.remoting.impl.invm.InVMConnection;
import org.hornetq.core.remoting.impl.invm.InVMConnector;
import org.hornetq.core.remoting.impl.invm.InVMRegistry;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.server.management.NotificationService;
import org.hornetq.spi.core.protocol.ProtocolType;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.utils.ConfigurationHelper;
import org.hornetq.utils.ExecutorFactory;
import org.hornetq.utils.OrderedExecutorFactory;
import org.hornetq.utils.TypedProperties;

public class InVMAcceptor
implements Acceptor {
    private static final Logger log = Logger.getLogger(InVMAcceptor.class);
    private final int id;
    private final BufferHandler handler;
    private final ConnectionLifeCycleListener listener;
    private final ConcurrentMap<String, Connection> connections = new ConcurrentHashMap<String, Connection>();
    private volatile boolean started;
    private final ExecutorFactory executorFactory;
    private boolean paused;
    private NotificationService notificationService;

    public InVMAcceptor(Map<String, Object> configuration, BufferHandler handler, ConnectionLifeCycleListener listener, Executor threadPool) {
        this.handler = handler;
        this.listener = listener;
        this.id = ConfigurationHelper.getIntProperty("server-id", 0, configuration);
        this.executorFactory = new OrderedExecutorFactory(threadPool);
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        InVMRegistry.instance.registerAcceptor(this.id, this);
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("factory"), new SimpleString(InVMAcceptorFactory.class.getName()));
            props.putIntProperty(new SimpleString("id"), this.id);
            Notification notification = new Notification(null, NotificationType.ACCEPTOR_STARTED, props);
            this.notificationService.sendNotification(notification);
        }
        this.started = true;
        this.paused = false;
    }

    @Override
    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        if (!this.paused) {
            InVMRegistry.instance.unregisterAcceptor(this.id);
        }
        for (Connection connection : this.connections.values()) {
            this.listener.connectionDestroyed(connection.getID());
        }
        this.connections.clear();
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("factory"), new SimpleString(InVMAcceptorFactory.class.getName()));
            props.putIntProperty(new SimpleString("id"), this.id);
            Notification notification = new Notification(null, NotificationType.ACCEPTOR_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.started = false;
        this.paused = false;
    }

    @Override
    public synchronized boolean isStarted() {
        return this.started;
    }

    @Override
    public synchronized void pause() {
        if (!this.started || this.paused) {
            return;
        }
        InVMRegistry.instance.unregisterAcceptor(this.id);
        this.paused = true;
    }

    @Override
    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public BufferHandler getHandler() {
        if (!this.started) {
            throw new IllegalStateException("Acceptor is not started");
        }
        return this.handler;
    }

    public ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    public void connect(String connectionID, BufferHandler remoteHandler, InVMConnector connector, Executor clientExecutor) {
        if (!this.started) {
            throw new IllegalStateException("Acceptor is not started");
        }
        new InVMConnection(this.id, connectionID, remoteHandler, new Listener(connector), clientExecutor);
    }

    public void disconnect(String connectionID) {
        if (!this.started) {
            return;
        }
        Connection conn = (Connection)this.connections.get(connectionID);
        if (conn != null) {
            conn.close();
        }
    }

    private class Listener
    implements ConnectionLifeCycleListener {
        private final InVMConnector connector;

        Listener(InVMConnector connector) {
            this.connector = connector;
        }

        @Override
        public void connectionCreated(Connection connection, ProtocolType protocol) {
            if (InVMAcceptor.this.connections.putIfAbsent((String)connection.getID(), connection) != null) {
                throw new IllegalArgumentException("Connection already exists with id " + connection.getID());
            }
            InVMAcceptor.this.listener.connectionCreated(connection, protocol);
        }

        @Override
        public void connectionDestroyed(final Object connectionID) {
            if (InVMAcceptor.this.connections.remove(connectionID) != null) {
                InVMAcceptor.this.listener.connectionDestroyed(connectionID);
                new Thread(){

                    @Override
                    public void run() {
                        Listener.this.connector.disconnect((String)connectionID);
                    }
                }.start();
            }
        }

        @Override
        public void connectionException(Object connectionID, HornetQException me) {
            InVMAcceptor.this.listener.connectionException(connectionID, me);
        }
    }
}

