/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.server.Bindable;
import org.hornetq.core.server.Consumer;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.transaction.Transaction;

public interface Queue
extends Bindable {
    public SimpleString getName();

    public long getID();

    public Filter getFilter();

    public boolean isDurable();

    public boolean isTemporary();

    public void addConsumer(Consumer var1) throws Exception;

    public void removeConsumer(Consumer var1) throws Exception;

    public int getConsumerCount();

    public void addLast(MessageReference var1);

    public void addFirst(MessageReference var1);

    public void acknowledge(MessageReference var1) throws Exception;

    public void acknowledge(Transaction var1, MessageReference var2) throws Exception;

    public void reacknowledge(Transaction var1, MessageReference var2) throws Exception;

    public void cancel(Transaction var1, MessageReference var2) throws Exception;

    public void cancel(MessageReference var1) throws Exception;

    public void deliverAsync();

    public int getMessageCount();

    public int getDeliveringCount();

    public void referenceHandled();

    public int getScheduledCount();

    public List<MessageReference> getScheduledMessages();

    public long getMessagesAdded();

    public MessageReference removeReferenceWithID(long var1) throws Exception;

    public MessageReference removeFirstReference(long var1) throws Exception;

    public MessageReference getReference(long var1);

    public int deleteAllReferences() throws Exception;

    public boolean deleteReference(long var1) throws Exception;

    public int deleteMatchingReferences(Filter var1) throws Exception;

    public boolean expireReference(long var1) throws Exception;

    public int expireReferences(Filter var1) throws Exception;

    public void expireReferences() throws Exception;

    public void expire(MessageReference var1) throws Exception;

    public boolean sendMessageToDeadLetterAddress(long var1) throws Exception;

    public int sendMessagesToDeadLetterAddress(Filter var1) throws Exception;

    public boolean changeReferencePriority(long var1, byte var3) throws Exception;

    public int changeReferencesPriority(Filter var1, byte var2) throws Exception;

    public boolean moveReference(long var1, SimpleString var3) throws Exception;

    public int moveReferences(Filter var1, SimpleString var2) throws Exception;

    public void addRedistributor(long var1);

    public void cancelRedistributor() throws Exception;

    public boolean hasMatchingConsumer(ServerMessage var1);

    public Collection<Consumer> getConsumers();

    public boolean checkDLQ(MessageReference var1) throws Exception;

    public Iterator<MessageReference> iterator();

    public void setExpiryAddress(SimpleString var1);

    public void pause();

    public void resume();

    public boolean isPaused();

    public Executor getExecutor();
}

