/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.impl.QueueImpl;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;

public class LastValueQueue
extends QueueImpl {
    private static final Logger log = Logger.getLogger(LastValueQueue.class);
    private final Map<SimpleString, HolderReference> map = new ConcurrentHashMap<SimpleString, HolderReference>();

    public LastValueQueue(long persistenceID, SimpleString address, SimpleString name, Filter filter, boolean durable, boolean temporary, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, Executor executor) {
        super(persistenceID, address, name, filter, durable, temporary, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor);
    }

    @Override
    public synchronized void add(MessageReference ref, boolean first) {
        SimpleString prop = ref.getMessage().getSimpleStringProperty(Message.HDR_LAST_VALUE_NAME);
        if (prop != null) {
            HolderReference hr = this.map.get(prop);
            if (!first) {
                if (hr != null) {
                    MessageReference oldRef = hr.getReference();
                    super.referenceHandled();
                    try {
                        super.acknowledge(oldRef);
                    }
                    catch (Exception e) {
                        log.error("Failed to ack old reference", e);
                    }
                    hr.setReference(ref);
                } else {
                    hr = new HolderReference(prop, ref);
                    this.map.put(prop, hr);
                    super.add(hr, first);
                }
            } else if (hr != null) {
                super.referenceHandled();
                try {
                    super.acknowledge(ref);
                }
                catch (Exception e) {
                    log.error("Failed to ack old reference", e);
                }
            } else {
                this.map.put(prop, (HolderReference)ref);
                super.add(ref, first);
            }
        } else {
            super.add(ref, first);
        }
    }

    private class HolderReference
    implements MessageReference {
        private final SimpleString prop;
        private volatile MessageReference ref;

        HolderReference(SimpleString prop, MessageReference ref) {
            this.prop = prop;
            this.ref = ref;
        }

        MessageReference getReference() {
            return this.ref;
        }

        @Override
        public void handled() {
            LastValueQueue.this.map.remove(this.prop);
        }

        void setReference(MessageReference ref) {
            this.ref = ref;
        }

        @Override
        public MessageReference copy(Queue queue) {
            return this.ref.copy(queue);
        }

        @Override
        public void decrementDeliveryCount() {
            this.ref.decrementDeliveryCount();
        }

        @Override
        public int getDeliveryCount() {
            return this.ref.getDeliveryCount();
        }

        @Override
        public ServerMessage getMessage() {
            return this.ref.getMessage();
        }

        @Override
        public Queue getQueue() {
            return this.ref.getQueue();
        }

        @Override
        public long getScheduledDeliveryTime() {
            return this.ref.getScheduledDeliveryTime();
        }

        @Override
        public void incrementDeliveryCount() {
            this.ref.incrementDeliveryCount();
        }

        @Override
        public void setDeliveryCount(int deliveryCount) {
            this.ref.setDeliveryCount(deliveryCount);
        }

        @Override
        public void setScheduledDeliveryTime(long scheduledDeliveryTime) {
            this.ref.setScheduledDeliveryTime(scheduledDeliveryTime);
        }
    }
}

