/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.lang.reflect.Array;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.core.logging.Logger;
import org.hornetq.utils.ConcurrentHQDeque;
import org.hornetq.utils.HQDeque;
import org.hornetq.utils.NonConcurrentHQDeque;
import org.hornetq.utils.PriorityLinkedList;
import org.hornetq.utils.concurrent.HQIterator;

public class PriorityLinkedListImpl<T>
implements PriorityLinkedList<T> {
    private static final Logger log = Logger.getLogger(PriorityLinkedListImpl.class);
    private HQDeque<T>[] levels;
    private final int priorities;
    private final AtomicInteger size = new AtomicInteger(0);

    public PriorityLinkedListImpl(boolean concurrent, int priorities) {
        this.priorities = priorities;
        this.levels = (HQDeque[])Array.newInstance(HQDeque.class, priorities);
        for (int i = 0; i < priorities; ++i) {
            this.levels[i] = concurrent ? new ConcurrentHQDeque() : new NonConcurrentHQDeque();
        }
    }

    @Override
    public int addFirst(T t, int priority) {
        this.levels[priority].addFirst(t);
        return this.size.incrementAndGet();
    }

    @Override
    public int addLast(T t, int priority) {
        this.levels[priority].addLast(t);
        return this.size.incrementAndGet();
    }

    @Override
    public T removeFirst() {
        T t = null;
        for (int i = this.priorities - 1; i >= 0; --i) {
            HQDeque<T> ll = this.levels[i];
            if (ll.isEmpty()) continue;
            t = ll.removeFirst();
            break;
        }
        if (t != null) {
            this.size.decrementAndGet();
        }
        return t;
    }

    @Override
    public T peekFirst() {
        T t = null;
        for (int i = this.priorities - 1; i >= 0; --i) {
            HQDeque<T> ll = this.levels[i];
            if (!ll.isEmpty()) {
                t = ll.getFirst();
            }
            if (t != null) break;
        }
        return t;
    }

    @Override
    public void clear() {
        for (HQDeque<T> list : this.levels) {
            list.clear();
        }
        this.size.set(0);
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    @Override
    public HQIterator<T> iterator() {
        return new PriorityLinkedListIterator();
    }

    private class PriorityLinkedListIterator
    implements HQIterator<T> {
        private int index;
        private HQIterator<T>[] cachedIters;

        PriorityLinkedListIterator() {
            this.cachedIters = new HQIterator[PriorityLinkedListImpl.this.levels.length];
            this.index = PriorityLinkedListImpl.this.levels.length - 1;
        }

        @Override
        public T next() {
            while (this.index >= 0) {
                Object t;
                HQIterator iter = this.cachedIters[this.index];
                if (iter == null) {
                    this.cachedIters[this.index] = PriorityLinkedListImpl.this.levels[this.index].iterator();
                    iter = this.cachedIters[this.index];
                }
                if ((t = iter.next()) != null) {
                    return t;
                }
                --this.index;
                if (this.index >= 0) continue;
                this.index = PriorityLinkedListImpl.this.levels.length - 1;
                break;
            }
            return null;
        }

        @Override
        public void remove() {
            HQIterator iter = this.cachedIters[this.index];
            if (iter == null) {
                throw new NoSuchElementException();
            }
            iter.remove();
            PriorityLinkedListImpl.this.size.decrementAndGet();
        }
    }
}

