/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.util;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class ArrayUtil {
    public static void dumpArray(PrintStream out, Object[] array) {
        out.print("{ ");
        for (int i = 0; i < array.length; ++i) {
            out.print(array[i].toString());
            if (i == array.length - 1) continue;
            out.print(", ");
        }
        out.print(" }");
    }

    public static Object[] merge(Object[][] arrays, Object[] arrType) {
        int i;
        int size = 0;
        for (i = 0; i < arrays.length; ++i) {
            size += arrays[i].length;
        }
        ArrayList<Object> res = new ArrayList<Object>(size);
        for (i = 0; i < arrays.length; ++i) {
            for (int j = 0; j < arrays[i].length; ++j) {
                res.add(arrays[i][j]);
            }
        }
        return res.toArray(arrType);
    }

    public static Object[] merge(Object[] one, Object[] two, Object[] arrType) {
        return ArrayUtil.merge(new Object[][]{one, two}, arrType);
    }

    public static int max(double[] values) {
        int maxIdx = -1;
        for (int i = 0; i < values.length; ++i) {
            if (maxIdx != -1 && !(values[i] > values[maxIdx])) continue;
            maxIdx = i;
        }
        return maxIdx;
    }

    public static int max(int[] values) {
        int maxIdx = -1;
        for (int i = 0; i < values.length; ++i) {
            if (maxIdx != -1 && values[i] <= values[maxIdx]) continue;
            maxIdx = i;
        }
        return maxIdx;
    }

    public static int min(double[] values) {
        int minIdx = -1;
        for (int i = 0; i < values.length; ++i) {
            if (minIdx != -1 && !(values[i] < values[minIdx])) continue;
            minIdx = i;
        }
        return minIdx;
    }

    public static double average(double[] values) {
        double sum = 0.0;
        if (values.length == 0) {
            throw new IllegalArgumentException("Array length must be > 0");
        }
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        return sum / (double)values.length;
    }

    public static double[] uniq(double[] values) {
        ArrayList<Double> arr = new ArrayList<Double>();
        double lastVal = 0.0;
        for (int i = 0; i < values.length; ++i) {
            if (i != 0 && lastVal == values[i]) continue;
            arr.add(new Double(values[i]));
            lastVal = values[i];
        }
        double[] res = new double[arr.size()];
        int j = 0;
        for (Double d : arr) {
            res[j++] = d;
        }
        return res;
    }

    public static boolean isUniq(String[] values) {
        for (int i = 0; i < values.length - 1; ++i) {
            if (!values[i].equals(values[i + 1])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] a1, Object[] a2) {
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == null) {
                if (a2[i] == null) continue;
                return false;
            }
            if (a2[i] == null) {
                return false;
            }
            if (a1[i].equals(a2[i])) continue;
            return false;
        }
        return true;
    }

    public static int findMinDiff(double[] values) {
        if (values.length < 2) {
            throw new IllegalArgumentException("Array length must be >= 2");
        }
        int minIdx = 0;
        double minDiff = values[1] - values[0];
        for (int i = 1; i < values.length - 1; ++i) {
            double diff = values[i + 1] - values[i];
            if (!(diff < minDiff)) continue;
            minDiff = diff;
            minIdx = i;
        }
        return minIdx;
    }

    public static boolean exists(Object[] array, Object element) {
        if (element == null) {
            return false;
        }
        HashSet<Object> set = new HashSet<Object>(Arrays.asList(array));
        return set.contains(element);
    }

    public static int find(Object[] array, Object element) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(element)) continue;
            return i;
        }
        return -1;
    }

    public static Integer[] stringToInteger(String[] array) {
        if (null != array) {
            Integer[] intArray = new Integer[array.length];
            for (int i = 0; i < array.length; ++i) {
                intArray[i] = new Integer(array[i]);
            }
            return intArray;
        }
        return null;
    }

    public static int[] stringToInt(String[] array) {
        if (null != array) {
            int[] intArray = new int[array.length];
            for (int i = 0; i < array.length; ++i) {
                intArray[i] = Integer.parseInt(array[i]);
            }
            return intArray;
        }
        return null;
    }

    public static Object[] combine(Object[] a1, Object[] a2) {
        Object[] r;
        if (a1 == null) {
            if (a2 == null) {
                return null;
            }
            Class<?> c = a2.getClass().getComponentType();
            r = (Object[])Array.newInstance(c, a2.length);
            System.arraycopy(a2, 0, r, 0, a2.length);
        } else if (a2 == null) {
            Class<?> c = a1.getClass().getComponentType();
            r = (Object[])Array.newInstance(c, a1.length);
            System.arraycopy(a1, 0, r, 0, a1.length);
        } else {
            Class<?> c = a1.getClass().getComponentType();
            r = (Object[])Array.newInstance(c, a1.length + a2.length);
            System.arraycopy(a1, 0, r, 0, a1.length);
            System.arraycopy(a2, 0, r, a1.length, a2.length);
        }
        return r;
    }
}

