/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.annotations;

import java.net.URL;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.mcann.AnnotationRepository;
import org.jboss.mcann.repository.Configuration;
import org.jboss.mcann.scanner.ModuleAnnotationScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericAnnotationDeployer
extends AbstractSimpleRealDeployer<Module> {
    private Configuration configuration;

    public GenericAnnotationDeployer() {
        super(Module.class);
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.setOutput(AnnotationRepository.class);
    }

    public void deploy(DeploymentUnit unit, Module deployment) throws DeploymentException {
        try {
            ModuleAnnotationScanner scanner = new ModuleAnnotationScanner(deployment);
            if (this.configuration != null) {
                scanner.setConfiguration(this.configuration);
            }
            AnnotationRepository repository = scanner.scan(unit.getClassLoader(), new URL[0]);
            unit.addAttachment(AnnotationRepository.class, (Object)repository);
        }
        catch (Exception e) {
            throw DeploymentException.rethrowAsDeploymentException((String)"Cannot create AR", (Throwable)e);
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

