/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.SharedRelationships;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class SharedRelationshipsHandler
extends AbstractHandler {
    public static final String TAG_NAME = "sharedRelationships";
    private HandlerMaker maker = null;

    protected SharedRelationshipsHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        SharedRelationships obj = new SharedRelationships();
        Vector nodeList = null;
        AbstractHandler handler = null;
        String direction = element.getAttribute("direction");
        if (direction != null && direction.trim().length() > 0) {
            obj.setDirection(direction);
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "keyedReference");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("keyedReference");
            obj.addKeyedReference((KeyedReference)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        Vector keyedRefVector;
        SharedRelationships relationships = (SharedRelationships)object;
        Element element = parent.getOwnerDocument().createElementNS(null, TAG_NAME);
        String direction = relationships.getDirection();
        if (direction != null && direction.length() > 0) {
            element.setAttribute("direction", direction);
        }
        if ((keyedRefVector = relationships.getKeyedReferenceVector()) != null && keyedRefVector.size() > 0) {
            AbstractHandler handler = this.maker.lookup("keyedReference");
            for (int i = 0; i < keyedRefVector.size(); ++i) {
                handler.marshal((KeyedReference)keyedRefVector.elementAt(i), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        SharedRelationships relationships = new SharedRelationships();
        relationships.setDirection("toKey");
        relationships.addKeyedReference(new KeyedReference("sharedRefKeyName", "sharedRefKeyValue"));
        relationships.addKeyedReference(new KeyedReference("uuid:8ff45356-acde-4a4c-86bf-f953611d20c6", "sharedRefKeyName2", "sharedRefKeyValue2"));
        System.out.println();
        RegistryObject regObject = relationships;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

