/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb.jboss;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.RemoteHome;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.creator.ejb.AbstractHomeProcessor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;

public class RemoteHomeProcessor
extends AbstractHomeProcessor
implements Processor<JBossSessionBeanMetaData, Class<?>> {
    public RemoteHomeProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    public void process(JBossSessionBeanMetaData metaData, Class<?> type) {
        RemoteHome remote = (RemoteHome)this.finder.getAnnotation(type, RemoteHome.class);
        if (remote == null) {
            return;
        }
        Class remoteHome = remote.value();
        if (!EJBHome.class.isAssignableFrom(remoteHome)) {
            throw new IllegalStateException("Declared EJB 2.1 Home Interface " + remoteHome.getName() + " does not extend " + EJBHome.class.getName() + " as required by EJB 3.0 Core Specification 4.6.8");
        }
        metaData.setHome(remoteHome.getName());
        this.setRemote(metaData, remoteHome, metaData.isStateless());
    }

    private void setRemote(JBossSessionBeanMetaData metaData, Class<?> remoteHome, boolean isStateless) {
        Class<?> businessInterface = RemoteHomeProcessor.getCreateReturnSignature(remoteHome, metaData.isStateless());
        if (!EJBObject.class.isAssignableFrom(businessInterface)) {
            throw new IllegalStateException("EJB 3.0 Core Specification Violation (4.6.7): The session bean\u00e2\u20ac\u2122s remote interface " + businessInterface + " must extend the javax.ejb.EJBObject interface.");
        }
        if (metaData.getRemote() != null && !metaData.getRemote().equals(businessInterface.getName())) {
            throw new IllegalStateException("2.1 bean " + metaData.getEjbName() + " already has a remote interface " + metaData.getRemote() + ", can't add " + businessInterface.getName());
        }
        metaData.setRemote(businessInterface.getName());
    }

    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(RemoteHome.class);
    }
}

