/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.DefaultProjectDependencyGraph;
import org.apache.maven.DuplicateProjectException;
import org.apache.maven.FilteredProjectDependencyGraph;
import org.apache.maven.InternalErrorException;
import org.apache.maven.Maven;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.ProjectCycleException;
import org.apache.maven.ReactorArtifactRepository;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemUtils;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.UrlModelSource;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectSorter;
import org.apache.maven.repository.DelegatingLocalArtifactRepository;
import org.apache.maven.repository.LocalRepositoryNotAccessibleException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.dag.CycleDetectedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=Maven.class)
public class DefaultMaven
implements Maven {
    @Requirement
    private Logger logger;
    @Requirement
    protected ProjectBuilder projectBuilder;
    @Requirement
    protected LifecycleExecutor lifecycleExecutor;
    @Requirement
    protected PlexusContainer container;
    @Requirement
    MavenExecutionRequestPopulator populator;
    @Requirement
    private ExecutionEventCatapult eventCatapult;

    @Override
    public MavenExecutionResult execute(MavenExecutionRequest request) {
        MavenExecutionResult result;
        try {
            result = this.doExecute(this.populator.populateDefaults(request));
        }
        catch (OutOfMemoryError e) {
            result = this.processResult(new DefaultMavenExecutionResult(), e);
        }
        catch (MavenExecutionRequestPopulationException e) {
            result = this.processResult(new DefaultMavenExecutionResult(), e);
        }
        catch (RuntimeException e) {
            result = this.processResult(new DefaultMavenExecutionResult(), new InternalErrorException("Internal error: " + e, e));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenExecutionResult doExecute(MavenExecutionRequest request) {
        List<MavenProject> projects;
        if (request.getStartTime() != null) {
            request.getSystemProperties().put("${build.timestamp}", new SimpleDateFormat("yyyyMMdd-hhmm").format(request.getStartTime()));
        }
        request.setStartTime(new Date());
        DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
        try {
            this.validateLocalRepository(request);
        }
        catch (LocalRepositoryNotAccessibleException e) {
            return this.processResult(result, e);
        }
        DelegatingLocalArtifactRepository delegatingLocalArtifactRepository = new DelegatingLocalArtifactRepository(request.getLocalRepository());
        request.setLocalRepository(delegatingLocalArtifactRepository);
        MavenSession session = new MavenSession(this.container, request, result);
        try {
            for (AbstractMavenLifecycleParticipant listener : this.getLifecycleParticipants(Collections.<MavenProject>emptyList())) {
                listener.afterSessionStart(session);
            }
        }
        catch (MavenExecutionException e) {
            return this.processResult(result, e);
        }
        this.eventCatapult.fire(ExecutionEvent.Type.ProjectDiscoveryStarted, session, null);
        try {
            projects = this.getProjectsForMavenReactor(request);
        }
        catch (ProjectBuildingException e) {
            return this.processResult(result, e);
        }
        session.setProjects(projects);
        result.setTopologicallySortedProjects(session.getProjects());
        result.setProject(session.getTopLevelProject());
        try {
            Map<String, MavenProject> projectMap = this.getProjectMap(session.getProjects());
            delegatingLocalArtifactRepository.setBuildReactor(new ReactorArtifactRepository(projectMap));
        }
        catch (DuplicateProjectException e) {
            return this.processResult(result, e);
        }
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            for (AbstractMavenLifecycleParticipant listener : this.getLifecycleParticipants(projects)) {
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                listener.afterProjectsRead(session);
            }
        }
        catch (MavenExecutionException e) {
            MavenExecutionResult listener = this.processResult(result, e);
            return listener;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        try {
            ProjectSorter projectSorter = new ProjectSorter(session.getProjects());
            ProjectDependencyGraph projectDependencyGraph = this.createDependencyGraph(projectSorter, request);
            session.setProjects(projectDependencyGraph.getSortedProjects());
            session.setProjectDependencyGraph(projectDependencyGraph);
        }
        catch (CycleDetectedException e) {
            String message = "The projects in the reactor contain a cyclic reference: " + e.getMessage();
            ProjectCycleException error = new ProjectCycleException(message, e);
            return this.processResult(result, error);
        }
        catch (org.apache.maven.project.DuplicateProjectException e) {
            return this.processResult(result, e);
        }
        catch (MavenExecutionException e) {
            return this.processResult(result, e);
        }
        result.setTopologicallySortedProjects(session.getProjects());
        if (result.hasExceptions()) {
            return result;
        }
        this.lifecycleExecutor.execute(session);
        this.validateActivatedProfiles(session.getProjects(), request.getActiveProfiles());
        if (session.getResult().hasExceptions()) {
            return this.processResult(result, session.getResult().getExceptions().get(0));
        }
        return result;
    }

    private void validateLocalRepository(MavenExecutionRequest request) throws LocalRepositoryNotAccessibleException {
        File localRepoDir = request.getLocalRepositoryPath();
        this.logger.debug("Using local repository at " + localRepoDir);
        localRepoDir.mkdirs();
        if (!localRepoDir.isDirectory()) {
            throw new LocalRepositoryNotAccessibleException("Could not create local repository at " + localRepoDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<AbstractMavenLifecycleParticipant> getLifecycleParticipants(Collection<MavenProject> projects) {
        LinkedHashSet<AbstractMavenLifecycleParticipant> lifecycleListeners = new LinkedHashSet<AbstractMavenLifecycleParticipant>();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                lifecycleListeners.addAll(this.container.lookupList(AbstractMavenLifecycleParticipant.class));
            }
            catch (ComponentLookupException e) {
                this.logger.warn("Failed to lookup lifecycle participants: " + e.getMessage());
            }
            HashSet<ClassRealm> scannedRealms = new HashSet<ClassRealm>();
            for (MavenProject project : projects) {
                ClassRealm projectRealm = project.getClassRealm();
                if (projectRealm == null || !scannedRealms.add(projectRealm)) continue;
                Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
                try {
                    lifecycleListeners.addAll(this.container.lookupList(AbstractMavenLifecycleParticipant.class));
                }
                catch (ComponentLookupException e) {
                    this.logger.warn("Failed to lookup lifecycle participants: " + e.getMessage());
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return lifecycleListeners;
    }

    private MavenExecutionResult processResult(MavenExecutionResult result, Throwable e) {
        if (!result.getExceptions().contains(e)) {
            result.addException(e);
        }
        return result;
    }

    private List<MavenProject> getProjectsForMavenReactor(MavenExecutionRequest request) throws ProjectBuildingException {
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        if (request.getPom() == null) {
            UrlModelSource modelSource = new UrlModelSource(this.getClass().getResource("project/standalone.xml"));
            MavenProject project = this.projectBuilder.build((ModelSource)modelSource, request.getProjectBuildingRequest()).getProject();
            project.setExecutionRoot(true);
            projects.add(project);
            request.setProjectPresent(false);
            return projects;
        }
        List<File> files = Arrays.asList(request.getPom().getAbsoluteFile());
        this.collectProjects(projects, files, request);
        return projects;
    }

    private Map<String, MavenProject> getProjectMap(List<MavenProject> projects) throws DuplicateProjectException {
        LinkedHashMap<String, MavenProject> index = new LinkedHashMap<String, MavenProject>();
        LinkedHashMap<String, List<File>> collisions = new LinkedHashMap<String, List<File>>();
        for (MavenProject project : projects) {
            String projectId = ArtifactUtils.key((String)project.getGroupId(), (String)project.getArtifactId(), (String)project.getVersion());
            MavenProject collision = (MavenProject)index.get(projectId);
            if (collision == null) {
                index.put(projectId, project);
                continue;
            }
            ArrayList<File> pomFiles = (ArrayList<File>)collisions.get(projectId);
            if (pomFiles == null) {
                pomFiles = new ArrayList<File>(Arrays.asList(collision.getFile(), project.getFile()));
                collisions.put(projectId, pomFiles);
                continue;
            }
            pomFiles.add(project.getFile());
        }
        if (!collisions.isEmpty()) {
            throw new DuplicateProjectException("Two or more projects in the reactor have the same identifier, please make sure that <groupId>:<artifactId>:<version> is unique for each project: " + collisions, collisions);
        }
        return index;
    }

    private void collectProjects(List<MavenProject> projects, List<File> files, MavenExecutionRequest request) throws ProjectBuildingException {
        ProjectBuildingRequest projectBuildingRequest = request.getProjectBuildingRequest();
        List<ProjectBuildingResult> results = this.projectBuilder.build(files, request.isRecursive(), projectBuildingRequest);
        boolean problems = false;
        for (ProjectBuildingResult result : results) {
            projects.add(result.getProject());
            if (result.getProblems().isEmpty() || !this.logger.isWarnEnabled()) continue;
            this.logger.warn("");
            this.logger.warn("Some problems were encountered while building the effective model for " + result.getProject().getId());
            for (ModelProblem problem : result.getProblems()) {
                this.logger.warn(problem.getMessage() + " @ " + ModelProblemUtils.formatLocation((ModelProblem)problem, (String)result.getProjectId()));
            }
            problems = true;
        }
        if (problems) {
            this.logger.warn("");
            this.logger.warn("It is highly recommended to fix these problems because they threaten the stability of your build.");
            this.logger.warn("");
            this.logger.warn("For this reason, future Maven versions might no longer support building such malformed projects.");
            this.logger.warn("");
        }
    }

    private void validateActivatedProfiles(List<MavenProject> projects, List<String> activeProfileIds) {
        LinkedHashSet<String> notActivatedProfileIds = new LinkedHashSet<String>(activeProfileIds);
        for (MavenProject project : projects) {
            for (List<String> profileIds : project.getInjectedProfileIds().values()) {
                notActivatedProfileIds.removeAll(profileIds);
            }
        }
        for (String notActivatedProfileId : notActivatedProfileIds) {
            this.logger.warn("The requested profile \"" + notActivatedProfileId + "\" could not be activated because it does not exist.");
        }
    }

    protected Logger getLogger() {
        return this.logger;
    }

    private ProjectDependencyGraph createDependencyGraph(ProjectSorter sorter, MavenExecutionRequest request) throws MavenExecutionException {
        ProjectDependencyGraph graph = new DefaultProjectDependencyGraph(sorter);
        SequencedCollection<MavenProject> activeProjects = sorter.getSortedProjects();
        File reactorDirectory = request.getBaseDirectory() != null ? new File(request.getBaseDirectory()) : null;
        if (!request.getSelectedProjects().isEmpty()) {
            ArrayList<MavenProject> selectedProjects = new ArrayList<MavenProject>(request.getSelectedProjects().size());
            for (String selectedProject : request.getSelectedProjects()) {
                MavenProject project = null;
                for (MavenProject activeProject : activeProjects) {
                    if (!this.isMatchingProject(activeProject, selectedProject, reactorDirectory)) continue;
                    project = activeProject;
                    break;
                }
                if (project != null) {
                    selectedProjects.add(project);
                    continue;
                }
                throw new MavenExecutionException("Could not find the selected project in the reactor: " + selectedProject, request.getPom());
            }
            activeProjects = selectedProjects;
            boolean makeUpstream = false;
            boolean makeDownstream = false;
            if ("make-upstream".equals(request.getMakeBehavior())) {
                makeUpstream = true;
            } else if ("make-downstream".equals(request.getMakeBehavior())) {
                makeDownstream = true;
            } else if ("make-both".equals(request.getMakeBehavior())) {
                makeUpstream = true;
                makeDownstream = true;
            } else if (StringUtils.isNotEmpty((String)request.getMakeBehavior())) {
                throw new MavenExecutionException("Invalid reactor make behavior: " + request.getMakeBehavior(), request.getPom());
            }
            if (makeUpstream || makeDownstream) {
                activeProjects = new LinkedHashSet<MavenProject>(selectedProjects);
                for (MavenProject selectedProject : selectedProjects) {
                    if (makeUpstream) {
                        activeProjects.addAll(graph.getUpstreamProjects(selectedProject, true));
                    }
                    if (!makeDownstream) continue;
                    activeProjects.addAll(graph.getDownstreamProjects(selectedProject, true));
                }
            }
        }
        if (StringUtils.isNotEmpty((String)request.getResumeFrom())) {
            String selectedProject = request.getResumeFrom();
            ArrayList<MavenProject> projects = new ArrayList<MavenProject>(activeProjects.size());
            boolean resumed = false;
            for (MavenProject project : activeProjects) {
                if (!resumed && this.isMatchingProject(project, selectedProject, reactorDirectory)) {
                    resumed = true;
                }
                if (!resumed) continue;
                projects.add(project);
            }
            if (!resumed) {
                throw new MavenExecutionException("Could not find project to resume reactor build from: " + selectedProject + " vs " + activeProjects, request.getPom());
            }
            activeProjects = projects;
        }
        if (activeProjects.size() != sorter.getSortedProjects().size()) {
            graph = new FilteredProjectDependencyGraph(graph, activeProjects);
        }
        return graph;
    }

    private boolean isMatchingProject(MavenProject project, String selector, File reactorDirectory) {
        if (selector.indexOf(58) >= 0) {
            String id = ':' + project.getArtifactId();
            if (id.equals(selector)) {
                return true;
            }
            id = project.getGroupId() + id;
            if (id.equals(selector)) {
                return true;
            }
        } else if (reactorDirectory != null) {
            File selectedProject = new File(new File(reactorDirectory, selector).toURI().normalize());
            if (selectedProject.isFile()) {
                return selectedProject.equals(project.getFile());
            }
            if (selectedProject.isDirectory()) {
                return selectedProject.equals(project.getBasedir());
            }
        }
        return false;
    }
}

