/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.LocalArtifactRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReactorArtifactRepository
extends LocalArtifactRepository {
    private Map<String, MavenProject> reactorProjects;
    private Map<String, List<String>> availableVersions;
    private final int hashCode;

    public ReactorArtifactRepository(Map<String, MavenProject> reactorProjects) {
        this.reactorProjects = reactorProjects;
        this.hashCode = reactorProjects != null ? ((Object)reactorProjects.keySet()).hashCode() : 0;
        this.availableVersions = new HashMap<String, List<String>>(reactorProjects.size() * 2);
        for (MavenProject project : reactorProjects.values()) {
            String key = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
            List<String> versions = this.availableVersions.get(key);
            if (versions == null) {
                versions = new ArrayList<String>(1);
                this.availableVersions.put(key, versions);
            }
            versions.add(project.getVersion());
        }
    }

    @Override
    public Artifact find(Artifact artifact) {
        String projectKey = ArtifactUtils.key((Artifact)artifact);
        MavenProject project = this.reactorProjects.get(projectKey);
        if (project != null) {
            if ("pom".equals(artifact.getType())) {
                this.resolve(artifact, project.getFile());
            } else {
                Artifact projectArtifact = this.findMatchingArtifact(project, artifact);
                if (this.hasArtifactFileFromPackagePhase(projectArtifact)) {
                    this.resolve(artifact, projectArtifact.getFile());
                } else if (!project.hasCompletedPhase("package")) {
                    if (ReactorArtifactRepository.isTestArtifact(artifact)) {
                        if (project.hasCompletedPhase("test-compile")) {
                            this.resolve(artifact, new File(project.getBuild().getTestOutputDirectory()));
                        }
                    } else if (project.hasCompletedPhase("compile")) {
                        this.resolve(artifact, new File(project.getBuild().getOutputDirectory()));
                    }
                }
            }
        }
        return artifact;
    }

    private boolean hasArtifactFileFromPackagePhase(Artifact projectArtifact) {
        return projectArtifact != null && projectArtifact.getFile() != null && projectArtifact.getFile().exists();
    }

    private void resolve(Artifact artifact, File file) {
        artifact.setFile(file);
        artifact.setResolved(true);
        artifact.setRepository((ArtifactRepository)this);
    }

    @Override
    public List<String> findVersions(Artifact artifact) {
        String key = ArtifactUtils.versionlessKey((Artifact)artifact);
        List<String> versions = this.availableVersions.get(key);
        return versions != null ? Collections.unmodifiableList(versions) : Collections.emptyList();
    }

    @Override
    public String getId() {
        return "reactor";
    }

    @Override
    public boolean hasLocalMetadata() {
        return false;
    }

    private Artifact findMatchingArtifact(MavenProject project, Artifact requestedArtifact) {
        Artifact mainArtifact;
        String requestedDependencyConflictId = requestedArtifact.getDependencyConflictId();
        if (requestedDependencyConflictId.equals((mainArtifact = project.getArtifact()).getDependencyConflictId())) {
            return mainArtifact;
        }
        String requestedRepositoryConflictId = this.getRepositoryConflictId(requestedArtifact);
        if (requestedRepositoryConflictId.equals(this.getRepositoryConflictId(mainArtifact))) {
            return mainArtifact;
        }
        List<Artifact> attachedArtifacts = project.getAttachedArtifacts();
        if (attachedArtifacts != null && !attachedArtifacts.isEmpty()) {
            for (Artifact attachedArtifact : attachedArtifacts) {
                if (!requestedDependencyConflictId.equals(attachedArtifact.getDependencyConflictId())) continue;
                return attachedArtifact;
            }
            for (Artifact attachedArtifact : attachedArtifacts) {
                if (!requestedRepositoryConflictId.equals(this.getRepositoryConflictId(attachedArtifact))) continue;
                return attachedArtifact;
            }
        }
        return null;
    }

    private String getRepositoryConflictId(Artifact artifact) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(artifact.getGroupId());
        buffer.append(':').append(artifact.getArtifactId());
        if (artifact.getArtifactHandler() != null) {
            buffer.append(':').append(artifact.getArtifactHandler().getExtension());
        } else {
            buffer.append(':').append(artifact.getType());
        }
        if (artifact.hasClassifier()) {
            buffer.append(':').append(artifact.getClassifier());
        }
        return buffer.toString();
    }

    private static boolean isTestArtifact(Artifact artifact) {
        if ("test-jar".equals(artifact.getType())) {
            return true;
        }
        return "jar".equals(artifact.getType()) && "tests".equals(artifact.getClassifier());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReactorArtifactRepository other = (ReactorArtifactRepository)obj;
        return ReactorArtifactRepository.eq(this.reactorProjects.keySet(), other.reactorProjects.keySet());
    }

    @Override
    public boolean isProjectAware() {
        return true;
    }
}

