/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.RepositoryCache;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.ArtifactTransferListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRepositoryRequest
implements RepositoryRequest {
    private boolean offline;
    private boolean forceUpdate;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteRepositories;
    private RepositoryCache cache;
    private ArtifactTransferListener transferListener;

    public DefaultRepositoryRequest() {
    }

    public DefaultRepositoryRequest(RepositoryRequest repositoryRequest) {
        this.setLocalRepository(repositoryRequest.getLocalRepository());
        this.setRemoteRepositories((List)repositoryRequest.getRemoteRepositories());
        this.setOffline(repositoryRequest.isOffline());
        this.setCache(repositoryRequest.getCache());
        this.setForceUpdate(repositoryRequest.isForceUpdate());
        this.setTransferListener(repositoryRequest.getTransferListener());
    }

    public static RepositoryRequest getRepositoryRequest(MavenSession session, MavenProject project) {
        DefaultRepositoryRequest request = new DefaultRepositoryRequest();
        request.setCache(session.getRepositoryCache());
        request.setLocalRepository(session.getLocalRepository());
        if (project != null) {
            request.setRemoteRepositories(project.getPluginArtifactRepositories());
        }
        request.setOffline(session.isOffline());
        request.setForceUpdate(session.getRequest().isUpdateSnapshots());
        request.setTransferListener(session.getRequest().getTransferListener());
        return request;
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    @Override
    public DefaultRepositoryRequest setOffline(boolean offline) {
        this.offline = offline;
        return this;
    }

    @Override
    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    @Override
    public DefaultRepositoryRequest setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
        return this;
    }

    @Override
    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    @Override
    public DefaultRepositoryRequest setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
        return this;
    }

    @Override
    public List<ArtifactRepository> getRemoteRepositories() {
        if (this.remoteRepositories == null) {
            this.remoteRepositories = new ArrayList<ArtifactRepository>();
        }
        return this.remoteRepositories;
    }

    @Override
    public DefaultRepositoryRequest setRemoteRepositories(List<ArtifactRepository> remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
        return this;
    }

    @Override
    public RepositoryCache getCache() {
        return this.cache;
    }

    @Override
    public DefaultRepositoryRequest setCache(RepositoryCache cache) {
        this.cache = cache;
        return this;
    }

    @Override
    public ArtifactTransferListener getTransferListener() {
        return this.transferListener;
    }

    @Override
    public DefaultRepositoryRequest setTransferListener(ArtifactTransferListener transferListener) {
        this.transferListener = transferListener;
        return this;
    }
}

