/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.BuildFailure;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleNotFoundException;
import org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.apache.maven.lifecycle.internal.LifecycleDebugLogger;
import org.apache.maven.lifecycle.internal.LifecycleDependencyResolver;
import org.apache.maven.lifecycle.internal.LifecycleExecutionPlanCalculator;
import org.apache.maven.lifecycle.internal.ReactorContext;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=BuilderCommon.class)
public class BuilderCommon {
    @Requirement
    private LifecycleDebugLogger lifecycleDebugLogger;
    @Requirement
    private LifecycleExecutionPlanCalculator lifeCycleExecutionPlanCalculator;
    @Requirement
    private LifecycleDependencyResolver lifecycleDependencyResolver;
    @Requirement
    private ExecutionEventCatapult eventCatapult;

    public BuilderCommon() {
    }

    public BuilderCommon(LifecycleDebugLogger lifecycleDebugLogger, LifecycleExecutionPlanCalculator lifeCycleExecutionPlanCalculator, LifecycleDependencyResolver lifecycleDependencyResolver) {
        this.lifecycleDebugLogger = lifecycleDebugLogger;
        this.lifeCycleExecutionPlanCalculator = lifeCycleExecutionPlanCalculator;
        this.lifecycleDependencyResolver = lifecycleDependencyResolver;
    }

    public MavenExecutionPlan resolveBuildPlan(MavenSession session, MavenProject project, TaskSegment taskSegment, Set<Artifact> projectArtifacts) throws PluginNotFoundException, PluginResolutionException, LifecyclePhaseNotFoundException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException, NoPluginFoundForPrefixException, LifecycleNotFoundException, PluginVersionResolutionException, LifecycleExecutionException {
        MavenExecutionPlan executionPlan = this.lifeCycleExecutionPlanCalculator.calculateExecutionPlan(session, project, taskSegment.getTasks());
        this.lifecycleDebugLogger.debugProjectPlan(project, executionPlan);
        this.lifecycleDependencyResolver.resolveDependencies(taskSegment.isAggregating(), project, session, executionPlan, projectArtifacts);
        return executionPlan;
    }

    public void handleBuildError(ReactorContext buildContext, MavenSession rootSession, MavenProject mavenProject, Exception e, long buildStartTime) {
        buildContext.getResult().addException(e);
        long buildEndTime = System.currentTimeMillis();
        buildContext.getResult().addBuildSummary(new BuildFailure(mavenProject, buildEndTime - buildStartTime, e));
        this.eventCatapult.fire(ExecutionEvent.Type.ProjectFailed, rootSession, null);
        if (!"FAIL_NEVER".equals(rootSession.getReactorFailureBehavior())) {
            if ("FAIL_AT_END".equals(rootSession.getReactorFailureBehavior())) {
                buildContext.getReactorBuildStatus().blackList(mavenProject);
            } else if ("FAIL_FAST".equals(rootSession.getReactorFailureBehavior())) {
                buildContext.getReactorBuildStatus().halt();
            } else {
                throw new IllegalArgumentException("invalid reactor failure behavior " + rootSession.getReactorFailureBehavior());
            }
        }
    }

    public static void attachToThread(MavenProject currentProject) {
        ClassRealm projectRealm = currentProject.getClassRealm();
        if (projectRealm != null) {
            Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
        }
    }

    public static String getKey(MavenProject project) {
        return project.getGroupId() + ':' + project.getArtifactId() + ':' + project.getVersion();
    }
}

