/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.ProjectDependenciesResolver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.lifecycle.internal.DependencyContext;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=LifecycleDependencyResolver.class)
public class LifecycleDependencyResolver {
    @Requirement
    private ProjectDependenciesResolver projectDependenciesResolver;
    @Requirement
    private Logger logger;

    public LifecycleDependencyResolver() {
    }

    public LifecycleDependencyResolver(ProjectDependenciesResolver projectDependenciesResolver, Logger logger) {
        this.projectDependenciesResolver = projectDependenciesResolver;
        this.logger = logger;
    }

    public void resolveDependencies(boolean aggregating, MavenProject currentProject, MavenSession sessionForThisModule, MavenExecutionPlan executionPlan, Set<Artifact> projectArtifacts) throws LifecycleExecutionException {
        List<MavenProject> projectsToResolve = LifecycleDependencyResolver.getProjects(currentProject, sessionForThisModule, aggregating);
        this.resolveDependencies(aggregating, sessionForThisModule, executionPlan, projectsToResolve, projectArtifacts);
    }

    public static List<MavenProject> getProjects(MavenProject project, MavenSession session, boolean aggregator) {
        if (aggregator) {
            return session.getProjects();
        }
        return Collections.singletonList(project);
    }

    public void checkForUpdate(MavenSession session, DependencyContext dependenctContext) throws LifecycleExecutionException {
        if (dependenctContext.isSameButUpdatedProject(session)) {
            this.resolveProjectDependencies(dependenctContext.getLastProject(), dependenctContext.getScopesToCollect(), dependenctContext.getScopesToResolve(), session, dependenctContext.isAggregating(), new HashSet<Artifact>());
        }
        dependenctContext.setLastProject(session.getCurrentProject());
        dependenctContext.setLastDependencyArtifacts(session.getCurrentProject().getDependencyArtifacts());
    }

    private void resolveDependencies(boolean aggregating, MavenSession session, MavenExecutionPlan executionPlan, List<MavenProject> projectsToResolve, Set<Artifact> projectArtifacts) throws LifecycleExecutionException {
        for (MavenProject project : projectsToResolve) {
            this.resolveProjectDependencies(project, executionPlan.getRequiredCollectionScopes(), executionPlan.getRequiredResolutionScopes(), session, aggregating, projectArtifacts);
        }
    }

    private void resolveProjectDependencies(MavenProject project, Collection<String> scopesToCollect, Collection<String> scopesToResolve, MavenSession session, boolean aggregating, Set<Artifact> projectArtifacts) throws LifecycleExecutionException {
        Set<Artifact> artifacts = this.getProjectDependencies(project, scopesToCollect, scopesToResolve, session, aggregating, projectArtifacts);
        this.updateProjectArtifacts(project, artifacts);
    }

    private void updateProjectArtifacts(MavenProject project, Set<Artifact> artifacts) {
        project.setResolvedArtifacts(artifacts);
        if (project.getDependencyArtifacts() == null) {
            project.setDependencyArtifacts(this.getDependencyArtifacts(project, artifacts));
        }
    }

    private Set<Artifact> getProjectDependencies(MavenProject project, Collection<String> scopesToCollect, Collection<String> scopesToResolve, MavenSession session, boolean aggregating, Set<Artifact> projectArtifacts) throws LifecycleExecutionException {
        try {
            Set<Artifact> artifacts;
            try {
                artifacts = this.projectDependenciesResolver.resolve(project, scopesToCollect, scopesToResolve, session, projectArtifacts);
            }
            catch (MultipleArtifactsNotFoundException e) {
                artifacts = this.handleException(session, aggregating, e);
            }
            return artifacts;
        }
        catch (ArtifactResolutionException e) {
            throw new LifecycleExecutionException(null, project, e);
        }
        catch (ArtifactNotFoundException e) {
            throw new LifecycleExecutionException(null, project, e);
        }
    }

    private Set<Artifact> handleException(MavenSession session, boolean aggregating, MultipleArtifactsNotFoundException e) throws MultipleArtifactsNotFoundException {
        if (aggregating && this.areAllArtifactsInReactor(session.getProjects(), e.getMissingArtifacts())) {
            this.logger.warn("The following artifacts could not be resolved at this point of the build but seem to be part of the reactor:");
            for (Artifact artifact : e.getMissingArtifacts()) {
                this.logger.warn("o " + artifact.getId());
            }
        } else {
            throw e;
        }
        this.logger.warn("Try running the build up to the lifecycle phase \"package\"");
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>(e.getResolvedArtifacts());
        return artifacts;
    }

    private Set<Artifact> getDependencyArtifacts(MavenProject project, Set<Artifact> artifacts) {
        HashSet<String> directDependencies = new HashSet<String>(project.getDependencies().size() * 2);
        for (Dependency dependency : project.getDependencies()) {
            directDependencies.add(dependency.getManagementKey());
        }
        LinkedHashSet<Artifact> dependencyArtifacts = new LinkedHashSet<Artifact>(project.getDependencies().size() * 2);
        for (Artifact artifact : artifacts) {
            if (!directDependencies.contains(artifact.getDependencyConflictId())) continue;
            dependencyArtifacts.add(artifact);
        }
        return dependencyArtifacts;
    }

    private boolean areAllArtifactsInReactor(Collection<MavenProject> projects, Collection<Artifact> artifacts) {
        Set<String> projectKeys = this.getReactorProjectKeys(projects);
        for (Artifact artifact : artifacts) {
            String key = ArtifactUtils.key((Artifact)artifact);
            if (projectKeys.contains(key)) continue;
            return false;
        }
        return true;
    }

    private Set<String> getReactorProjectKeys(Collection<MavenProject> projects) {
        HashSet<String> projectKeys = new HashSet<String>(projects.size() * 2);
        for (MavenProject project : projects) {
            String key = ArtifactUtils.key((String)project.getGroupId(), (String)project.getArtifactId(), (String)project.getVersion());
            projectKeys.add(key);
        }
        return projectKeys;
    }
}

