/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.apache.maven.artifact.repository.DefaultRepositoryRequest;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.prefix.DefaultPluginPrefixRequest;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.prefix.PluginPrefixResolver;
import org.apache.maven.plugin.prefix.PluginPrefixResult;
import org.apache.maven.plugin.version.DefaultPluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=MojoDescriptorCreator.class)
public class MojoDescriptorCreator {
    @Requirement
    private PluginVersionResolver pluginVersionResolver;
    @Requirement
    private BuildPluginManager pluginManager;
    @Requirement
    private PluginPrefixResolver pluginPrefixResolver;

    public MojoDescriptorCreator() {
    }

    public MojoDescriptorCreator(PluginVersionResolver pluginVersionResolver, BuildPluginManager pluginManager, PluginPrefixResolver pluginPrefixResolver) {
        this.pluginVersionResolver = pluginVersionResolver;
        this.pluginManager = pluginManager;
        this.pluginPrefixResolver = pluginPrefixResolver;
    }

    private Plugin findPlugin(String groupId, String artifactId, Collection<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            if (!artifactId.equals(plugin.getArtifactId()) || !groupId.equals(plugin.getGroupId())) continue;
            return plugin;
        }
        return null;
    }

    public static Xpp3Dom convert(MojoDescriptor mojoDescriptor) {
        Xpp3Dom dom = new Xpp3Dom("configuration");
        PlexusConfiguration c = mojoDescriptor.getMojoConfiguration();
        PlexusConfiguration[] ces = c.getChildren();
        if (ces != null) {
            for (PlexusConfiguration ce : ces) {
                String value = ce.getValue(null);
                String defaultValue = ce.getAttribute("default-value", null);
                if (value == null && defaultValue == null) continue;
                Xpp3Dom e = new Xpp3Dom(ce.getName());
                e.setValue(value);
                if (defaultValue != null) {
                    e.setAttribute("default-value", defaultValue);
                }
                dom.addChild(e);
            }
        }
        return dom;
    }

    public MojoDescriptor getMojoDescriptor(String task, MavenSession session, MavenProject project) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException {
        String goal = null;
        Plugin plugin = null;
        StringTokenizer tok = new StringTokenizer(task, ":");
        int numTokens = tok.countTokens();
        if (numTokens == 4) {
            plugin = new Plugin();
            plugin.setGroupId(tok.nextToken());
            plugin.setArtifactId(tok.nextToken());
            plugin.setVersion(tok.nextToken());
            goal = tok.nextToken();
        } else if (numTokens == 3) {
            plugin = new Plugin();
            plugin.setGroupId(tok.nextToken());
            plugin.setArtifactId(tok.nextToken());
            goal = tok.nextToken();
        } else if (numTokens == 2) {
            String prefix = tok.nextToken();
            goal = tok.nextToken();
            plugin = this.findPluginForPrefix(prefix, session);
        }
        this.injectPluginDeclarationFromProject(plugin, project);
        RepositoryRequest repositoryRequest = DefaultRepositoryRequest.getRepositoryRequest(session, project);
        if (plugin.getVersion() == null) {
            this.resolvePluginVersion(plugin, repositoryRequest);
        }
        return this.pluginManager.getMojoDescriptor(plugin, goal, repositoryRequest);
    }

    public Plugin findPluginForPrefix(String prefix, MavenSession session) throws NoPluginFoundForPrefixException {
        DefaultPluginPrefixRequest prefixRequest = new DefaultPluginPrefixRequest(prefix, session);
        PluginPrefixResult prefixResult = this.pluginPrefixResolver.resolve(prefixRequest);
        Plugin plugin = new Plugin();
        plugin.setGroupId(prefixResult.getGroupId());
        plugin.setArtifactId(prefixResult.getArtifactId());
        return plugin;
    }

    private void resolvePluginVersion(Plugin plugin, RepositoryRequest repositoryRequest) throws PluginVersionResolutionException {
        DefaultPluginVersionRequest versionRequest = new DefaultPluginVersionRequest(plugin, repositoryRequest);
        plugin.setVersion(this.pluginVersionResolver.resolve(versionRequest).getVersion());
    }

    private void injectPluginDeclarationFromProject(Plugin plugin, MavenProject project) {
        Plugin pluginInPom = this.findPlugin(plugin, project.getBuildPlugins());
        if (pluginInPom == null && project.getPluginManagement() != null) {
            pluginInPom = this.findPlugin(plugin, project.getPluginManagement().getPlugins());
        }
        if (pluginInPom != null) {
            if (plugin.getVersion() == null) {
                plugin.setVersion(pluginInPom.getVersion());
            }
            plugin.setDependencies(new ArrayList(pluginInPom.getDependencies()));
        }
    }

    private Plugin findPlugin(Plugin plugin, Collection<Plugin> plugins) {
        return this.findPlugin(plugin.getGroupId(), plugin.getArtifactId(), plugins);
    }
}

