/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.PluginArtifactsCache;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=PluginArtifactsCache.class)
public class DefaultPluginArtifactsCache
implements PluginArtifactsCache {
    protected final Map<CacheKey, PluginArtifactsCache.CacheRecord> cache = new HashMap<CacheKey, PluginArtifactsCache.CacheRecord>();

    @Override
    public PluginArtifactsCache.CacheRecord get(Plugin plugin, RepositoryRequest repositoryRequest, ArtifactFilter extensionArtifactFilter) {
        return this.cache.get(new CacheKey(plugin, repositoryRequest, extensionArtifactFilter));
    }

    @Override
    public PluginArtifactsCache.CacheRecord put(Plugin plugin, RepositoryRequest repositoryRequest, ArtifactFilter extensionArtifactFilter, List<Artifact> pluginArtifacts) {
        if (pluginArtifacts == null) {
            throw new NullPointerException();
        }
        CacheKey key = new CacheKey(plugin, repositoryRequest, extensionArtifactFilter);
        if (this.cache.containsKey(key)) {
            throw new IllegalStateException("Duplicate artifact resolution result for plugin " + plugin.getId());
        }
        PluginArtifactsCache.CacheRecord record = new PluginArtifactsCache.CacheRecord(Collections.unmodifiableList(new ArrayList<Artifact>(pluginArtifacts)));
        this.cache.put(key, record);
        return record;
    }

    @Override
    public void flush() {
        this.cache.clear();
    }

    protected static int pluginHashCode(Plugin plugin) {
        int hash = 17;
        hash = hash * 31 + plugin.getGroupId().hashCode();
        hash = hash * 31 + plugin.getArtifactId().hashCode();
        hash = hash * 31 + plugin.getVersion().hashCode();
        for (Dependency dependency : plugin.getDependencies()) {
            hash = hash * 31 + dependency.getGroupId().hashCode();
            hash = hash * 31 + dependency.getArtifactId().hashCode();
            hash = hash * 31 + dependency.getVersion().hashCode();
            hash = hash * 31 + dependency.getType().hashCode();
            hash = hash * 31 + (dependency.getClassifier() != null ? dependency.getClassifier().hashCode() : 0);
            hash = hash * 31 + (dependency.getScope() != null ? dependency.getScope().hashCode() : 0);
            for (Exclusion exclusion : dependency.getExclusions()) {
                hash = hash * 31 + exclusion.getGroupId().hashCode();
                hash = hash * 31 + exclusion.getArtifactId().hashCode();
            }
        }
        return hash;
    }

    protected static boolean pluginEquals(Plugin a, Plugin b) {
        return DefaultPluginArtifactsCache.eq(a.getGroupId(), b.getGroupId()) && DefaultPluginArtifactsCache.eq(a.getArtifactId(), b.getArtifactId()) && DefaultPluginArtifactsCache.eq(a.getVersion(), b.getVersion()) && DefaultPluginArtifactsCache.dependenciesEquals(a.getDependencies(), b.getDependencies());
    }

    private static boolean dependenciesEquals(List<Dependency> a, List<Dependency> b) {
        if (a.size() != b.size()) {
            return false;
        }
        Iterator<Dependency> aI = a.iterator();
        Iterator<Dependency> bI = b.iterator();
        while (aI.hasNext()) {
            boolean r;
            Dependency aD = aI.next();
            Dependency bD = bI.next();
            boolean bl = r = DefaultPluginArtifactsCache.eq(aD.getGroupId(), bD.getGroupId()) && DefaultPluginArtifactsCache.eq(aD.getArtifactId(), bD.getArtifactId()) && DefaultPluginArtifactsCache.eq(aD.getVersion(), bD.getVersion()) && DefaultPluginArtifactsCache.eq(aD.getType(), bD.getType()) && DefaultPluginArtifactsCache.eq(aD.getClassifier(), bD.getClassifier()) && DefaultPluginArtifactsCache.eq(aD.getScope(), bD.getScope());
            if (r &= DefaultPluginArtifactsCache.exclusionsEquals(aD.getExclusions(), bD.getExclusions())) continue;
            return false;
        }
        return true;
    }

    private static boolean exclusionsEquals(List<Exclusion> a, List<Exclusion> b) {
        if (a.size() != b.size()) {
            return false;
        }
        Iterator<Exclusion> aI = a.iterator();
        Iterator<Exclusion> bI = b.iterator();
        while (aI.hasNext()) {
            Exclusion aD = aI.next();
            Exclusion bD = bI.next();
            boolean r = DefaultPluginArtifactsCache.eq(aD.getGroupId(), bD.getGroupId()) && DefaultPluginArtifactsCache.eq(aD.getArtifactId(), bD.getArtifactId());
            if (r) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    @Override
    public void register(MavenProject project, PluginArtifactsCache.CacheRecord record) {
    }

    private static class CacheKey {
        private final Plugin plugin;
        private final List<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
        private final ArtifactFilter extensionArtifactFilter;
        private final int hashCode;

        public CacheKey(Plugin plugin, RepositoryRequest repositoryRequest, ArtifactFilter extensionArtifactFilter) {
            this.plugin = plugin.clone();
            this.repositories.add(repositoryRequest.getLocalRepository());
            this.repositories.addAll(repositoryRequest.getRemoteRepositories());
            this.extensionArtifactFilter = extensionArtifactFilter;
            int hash = 17;
            hash = hash * 31 + DefaultPluginArtifactsCache.pluginHashCode(plugin);
            hash = hash * 31 + ((Object)this.repositories).hashCode();
            this.hashCode = hash = hash * 31 + (extensionArtifactFilter != null ? extensionArtifactFilter.hashCode() : 0);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            return DefaultPluginArtifactsCache.pluginEquals(this.plugin, other.plugin) && DefaultPluginArtifactsCache.eq(this.repositories, other.repositories) && DefaultPluginArtifactsCache.eq(this.extensionArtifactFilter, other.extensionArtifactFilter);
        }
    }
}

