/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.PluginRealmCache;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=PluginRealmCache.class)
public class DefaultPluginRealmCache
implements PluginRealmCache {
    protected final Map<CacheKey, PluginRealmCache.CacheRecord> cache = new ConcurrentHashMap<CacheKey, PluginRealmCache.CacheRecord>();

    @Override
    public PluginRealmCache.CacheRecord get(Plugin plugin, ClassLoader parentRealm, List<String> parentImports, ArtifactFilter dependencyFilter, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) {
        return this.cache.get(new CacheKey(plugin, parentRealm, parentImports, dependencyFilter, localRepository, remoteRepositories));
    }

    @Override
    public PluginRealmCache.CacheRecord put(Plugin plugin, ClassLoader parentRealm, List<String> parentImports, ArtifactFilter dependencyFilter, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ClassRealm pluginRealm, List<Artifact> pluginArtifacts) {
        if (pluginRealm == null || pluginArtifacts == null) {
            throw new NullPointerException();
        }
        CacheKey key = new CacheKey(plugin, parentRealm, parentImports, dependencyFilter, localRepository, remoteRepositories);
        if (this.cache.containsKey(key)) {
            throw new IllegalStateException("Duplicate plugin realm for plugin " + plugin.getId());
        }
        PluginRealmCache.CacheRecord record = new PluginRealmCache.CacheRecord(pluginRealm, pluginArtifacts);
        this.cache.put(key, record);
        return record;
    }

    @Override
    public void flush() {
        this.cache.clear();
    }

    protected static int pluginHashCode(Plugin plugin) {
        int hash = 17;
        hash = hash * 31 + plugin.getGroupId().hashCode();
        hash = hash * 31 + plugin.getArtifactId().hashCode();
        hash = hash * 31 + plugin.getVersion().hashCode();
        hash = hash * 31 + (plugin.isExtensions() ? 1 : 0);
        for (Dependency dependency : plugin.getDependencies()) {
            hash = hash * 31 + dependency.getGroupId().hashCode();
            hash = hash * 31 + dependency.getArtifactId().hashCode();
            hash = hash * 31 + dependency.getVersion().hashCode();
            hash = hash * 31 + dependency.getType().hashCode();
            hash = hash * 31 + (dependency.getClassifier() != null ? dependency.getClassifier().hashCode() : 0);
            hash = hash * 31 + (dependency.getScope() != null ? dependency.getScope().hashCode() : 0);
            for (Exclusion exclusion : dependency.getExclusions()) {
                hash = hash * 31 + exclusion.getGroupId().hashCode();
                hash = hash * 31 + exclusion.getArtifactId().hashCode();
            }
        }
        return hash;
    }

    protected static boolean pluginEquals(Plugin a, Plugin b) {
        return DefaultPluginRealmCache.eq(a.getGroupId(), b.getGroupId()) && DefaultPluginRealmCache.eq(a.getArtifactId(), b.getArtifactId()) && DefaultPluginRealmCache.eq(a.getVersion(), b.getVersion()) && a.isExtensions() == b.isExtensions() && DefaultPluginRealmCache.dependenciesEquals(a.getDependencies(), b.getDependencies());
    }

    private static boolean dependenciesEquals(List<Dependency> a, List<Dependency> b) {
        if (a.size() != b.size()) {
            return false;
        }
        Iterator<Dependency> aI = a.iterator();
        Iterator<Dependency> bI = b.iterator();
        while (aI.hasNext()) {
            boolean r;
            Dependency aD = aI.next();
            Dependency bD = bI.next();
            boolean bl = r = DefaultPluginRealmCache.eq(aD.getGroupId(), bD.getGroupId()) && DefaultPluginRealmCache.eq(aD.getArtifactId(), bD.getArtifactId()) && DefaultPluginRealmCache.eq(aD.getVersion(), bD.getVersion()) && DefaultPluginRealmCache.eq(aD.getType(), bD.getType()) && DefaultPluginRealmCache.eq(aD.getClassifier(), bD.getClassifier()) && DefaultPluginRealmCache.eq(aD.getScope(), bD.getScope());
            if (r &= DefaultPluginRealmCache.exclusionsEquals(aD.getExclusions(), bD.getExclusions())) continue;
            return false;
        }
        return true;
    }

    private static boolean exclusionsEquals(List<Exclusion> a, List<Exclusion> b) {
        if (a.size() != b.size()) {
            return false;
        }
        Iterator<Exclusion> aI = a.iterator();
        Iterator<Exclusion> bI = b.iterator();
        while (aI.hasNext()) {
            Exclusion aD = aI.next();
            Exclusion bD = bI.next();
            boolean r = DefaultPluginRealmCache.eq(aD.getGroupId(), bD.getGroupId()) && DefaultPluginRealmCache.eq(aD.getArtifactId(), bD.getArtifactId());
            if (r) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    @Override
    public void register(MavenProject project, PluginRealmCache.CacheRecord record) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CacheKey {
        private final Plugin plugin;
        private final List<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
        private final ClassLoader parentRealm;
        private final List<String> parentImports;
        private final ArtifactFilter filter;
        private final int hashCode;

        public CacheKey(Plugin plugin, ClassLoader parentRealm, List<String> parentImports, ArtifactFilter dependencyFilter, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) {
            this.plugin = plugin.clone();
            this.repositories.add(localRepository);
            this.repositories.addAll(remoteRepositories);
            this.parentRealm = parentRealm;
            this.parentImports = parentImports != null ? parentImports : Collections.emptyList();
            this.filter = dependencyFilter;
            int hash = 17;
            hash = hash * 31 + DefaultPluginRealmCache.pluginHashCode(plugin);
            hash = hash * 31 + ((Object)this.repositories).hashCode();
            hash = hash * 31 + (parentRealm != null ? parentRealm.hashCode() : 0);
            hash = hash * 31 + ((Object)this.parentImports).hashCode();
            this.hashCode = hash = hash * 31 + (dependencyFilter != null ? dependencyFilter.hashCode() : 0);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            return this.parentRealm == other.parentRealm && DefaultPluginRealmCache.pluginEquals(this.plugin, other.plugin) && DefaultPluginRealmCache.eq(this.repositories, other.repositories) && DefaultPluginRealmCache.eq(this.filter, other.filter) && DefaultPluginRealmCache.eq(this.parentImports, other.parentImports);
        }
    }
}

