/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.classrealm.ClassRealmManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.monitor.logging.DefaultLog;
import org.apache.maven.plugin.ContextEnabled;
import org.apache.maven.plugin.DebugConfigurationListener;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.MavenPluginValidator;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginContainerException;
import org.apache.maven.plugin.PluginDescriptorCache;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.PluginRealmCache;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.apache.maven.plugin.internal.PluginDependenciesResolver;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.composition.CycleDetectedInComponentGraphException;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=MavenPluginManager.class)
public class DefaultMavenPluginManager
implements MavenPluginManager {
    @Requirement
    private Logger logger;
    @Requirement
    private PlexusContainer container;
    @Requirement
    private ClassRealmManager classRealmManager;
    @Requirement
    private PluginDescriptorCache pluginDescriptorCache;
    @Requirement
    private PluginRealmCache pluginRealmCache;
    @Requirement
    private PluginDependenciesResolver pluginDependenciesResolver;
    private PluginDescriptorBuilder builder = new PluginDescriptorBuilder();

    @Override
    public synchronized PluginDescriptor getPluginDescriptor(Plugin plugin, RepositoryRequest repositoryRequest) throws PluginResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException {
        PluginDescriptorCache.Key cacheKey = this.pluginDescriptorCache.createKey(plugin, repositoryRequest);
        PluginDescriptor pluginDescriptor = this.pluginDescriptorCache.get(cacheKey);
        if (pluginDescriptor == null) {
            Artifact pluginArtifact = this.pluginDependenciesResolver.resolve(plugin, new ArtifactResolutionRequest(repositoryRequest));
            pluginDescriptor = this.extractPluginDescriptor(pluginArtifact, plugin);
            this.pluginDescriptorCache.put(cacheKey, pluginDescriptor);
        }
        pluginDescriptor.setPlugin(plugin);
        return pluginDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private PluginDescriptor extractPluginDescriptor(Artifact pluginArtifact, Plugin plugin) throws PluginDescriptorParsingException, InvalidPluginDescriptorException {
        pluginDescriptor = null;
        pluginFile = pluginArtifact.getFile();
        try {
            if (pluginFile.isFile()) {
                pluginJar = new JarFile(pluginFile, false);
                try {
                    pluginDescriptorEntry = pluginJar.getEntry(this.getPluginDescriptorLocation());
                    if (pluginDescriptorEntry == null) ** GOTO lbl24
                    is = pluginJar.getInputStream(pluginDescriptorEntry);
                    pluginDescriptor = this.parsePluginDescriptor(is, plugin, pluginFile.getAbsolutePath());
                }
                finally {
                    pluginJar.close();
                }
            } else {
                pluginXml = new File(pluginFile, this.getPluginDescriptorLocation());
                if (pluginXml.isFile()) {
                    is = new BufferedInputStream(new FileInputStream(pluginXml));
                    try {
                        pluginDescriptor = this.parsePluginDescriptor(is, plugin, pluginXml.getAbsolutePath());
                    }
                    finally {
                        IOUtil.close((InputStream)is);
                    }
                }
            }
            if (pluginDescriptor == null) {
                throw new IOException("No plugin descriptor found at " + this.getPluginDescriptorLocation());
            }
        }
        catch (IOException e) {
            throw new PluginDescriptorParsingException(plugin, pluginFile.getAbsolutePath(), e);
        }
        validator = new MavenPluginValidator(pluginArtifact);
        validator.validate(pluginDescriptor);
        if (validator.hasErrors()) {
            throw new InvalidPluginDescriptorException("Invalid plugin descriptor for " + plugin.getId() + " (" + pluginFile + ")", validator.getErrors());
        }
        pluginDescriptor.setPluginArtifact(pluginArtifact);
        return pluginDescriptor;
    }

    private String getPluginDescriptorLocation() {
        return "META-INF/maven/plugin.xml";
    }

    private PluginDescriptor parsePluginDescriptor(InputStream is, Plugin plugin, String descriptorLocation) throws PluginDescriptorParsingException {
        try {
            XmlStreamReader reader = ReaderFactory.newXmlReader((InputStream)is);
            PluginDescriptor pluginDescriptor = this.builder.build((Reader)reader, descriptorLocation);
            return pluginDescriptor;
        }
        catch (IOException e) {
            throw new PluginDescriptorParsingException(plugin, descriptorLocation, e);
        }
        catch (PlexusConfigurationException e) {
            throw new PluginDescriptorParsingException(plugin, descriptorLocation, e);
        }
    }

    @Override
    public MojoDescriptor getMojoDescriptor(Plugin plugin, String goal, RepositoryRequest repositoryRequest) throws MojoNotFoundException, PluginResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException {
        PluginDescriptor pluginDescriptor = this.getPluginDescriptor(plugin, repositoryRequest);
        MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(goal);
        if (mojoDescriptor == null) {
            throw new MojoNotFoundException(goal, pluginDescriptor);
        }
        return mojoDescriptor;
    }

    @Override
    public synchronized void setupPluginRealm(PluginDescriptor pluginDescriptor, MavenSession session, ClassLoader parent, List<String> imports, ArtifactFilter filter) throws PluginResolutionException, PluginContainerException {
        Plugin plugin = pluginDescriptor.getPlugin();
        MavenProject project = session.getCurrentProject();
        PluginRealmCache.CacheRecord cacheRecord = this.pluginRealmCache.get(plugin, parent, imports, filter, session.getLocalRepository(), project.getPluginArtifactRepositories());
        if (cacheRecord != null) {
            pluginDescriptor.setClassRealm(cacheRecord.realm);
            pluginDescriptor.setArtifacts(new ArrayList<Artifact>(cacheRecord.artifacts));
        } else {
            this.createPluginRealm(pluginDescriptor, session, parent, imports, filter);
            cacheRecord = this.pluginRealmCache.put(plugin, parent, imports, filter, session.getLocalRepository(), project.getPluginArtifactRepositories(), pluginDescriptor.getClassRealm(), pluginDescriptor.getArtifacts());
        }
        this.pluginRealmCache.register(project, cacheRecord);
    }

    private void createPluginRealm(PluginDescriptor pluginDescriptor, MavenSession session, ClassLoader parent, List<String> imports, ArtifactFilter filter) throws PluginResolutionException, PluginContainerException {
        Plugin plugin = pluginDescriptor.getPlugin();
        if (plugin == null) {
            throw new IllegalArgumentException("incomplete plugin descriptor, plugin missing");
        }
        Artifact pluginArtifact = pluginDescriptor.getPluginArtifact();
        if (pluginArtifact == null) {
            throw new IllegalArgumentException("incomplete plugin descriptor, plugin artifact missing");
        }
        MavenProject project = session.getCurrentProject();
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setLocalRepository(session.getLocalRepository());
        request.setRemoteRepositories((List)project.getPluginArtifactRepositories());
        request.setCache(session.getRepositoryCache());
        request.setOffline(session.isOffline());
        request.setForceUpdate(session.getRequest().isUpdateSnapshots());
        request.setServers(session.getRequest().getServers());
        request.setMirrors(session.getRequest().getMirrors());
        request.setProxies(session.getRequest().getProxies());
        request.setTransferListener(session.getRequest().getTransferListener());
        ArtifactFilter dependencyFilter = project.getExtensionArtifactFilter();
        if (dependencyFilter == null) {
            dependencyFilter = filter;
        } else if (filter != null) {
            dependencyFilter = new AndArtifactFilter(Arrays.asList(dependencyFilter, filter));
        }
        List<Artifact> pluginArtifacts = this.pluginDependenciesResolver.resolve(plugin, pluginArtifact, request, dependencyFilter);
        ClassRealm pluginRealm = this.classRealmManager.createPluginRealm(plugin, parent, imports, pluginArtifacts);
        ArrayList<Artifact> exposedPluginArtifacts = new ArrayList<Artifact>();
        for (Artifact artifact : pluginArtifacts) {
            if (artifact.getFile() == null) continue;
            exposedPluginArtifacts.add(artifact);
        }
        pluginDescriptor.setClassRealm(pluginRealm);
        pluginDescriptor.setArtifacts(exposedPluginArtifacts);
        try {
            for (ComponentDescriptor componentDescriptor : pluginDescriptor.getComponents()) {
                componentDescriptor.setRealm(pluginRealm);
                this.container.addComponentDescriptor(componentDescriptor);
            }
            this.container.discoverComponents(pluginRealm);
        }
        catch (PlexusConfigurationException e) {
            throw new PluginContainerException(plugin, pluginRealm, "Error in component graph of plugin " + plugin.getId() + ": " + e.getMessage(), e);
        }
        catch (CycleDetectedInComponentGraphException e) {
            throw new PluginContainerException(plugin, pluginRealm, "Error in component graph of plugin " + plugin.getId() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getConfiguredMojo(Class<T> mojoInterface, MavenSession session, MojoExecution mojoExecution) throws PluginConfigurationException, PluginContainerException {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
        ClassRealm pluginRealm = pluginDescriptor.getClassRealm();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Configuring mojo " + mojoDescriptor.getId() + " from plugin realm " + pluginRealm);
        }
        ClassRealm oldLookupRealm = this.container.setLookupRealm(pluginRealm);
        this.container.setLookupRealm(pluginRealm);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)pluginRealm);
        try {
            Xpp3Dom dom;
            MavenProject project;
            Map<String, Object> pluginContext;
            Object mojo;
            try {
                mojo = this.container.lookup(mojoInterface, mojoDescriptor.getRoleHint());
            }
            catch (ComponentLookupException e) {
                Throwable cause;
                for (cause = e.getCause(); cause != null && !(cause instanceof LinkageError) && !(cause instanceof ClassNotFoundException); cause = cause.getCause()) {
                }
                if (cause instanceof NoClassDefFoundError || cause instanceof ClassNotFoundException) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
                    PrintStream ps = new PrintStream(os);
                    ps.println("Unable to load the mojo '" + mojoDescriptor.getGoal() + "' in the plugin '" + pluginDescriptor.getId() + "'. A required class is missing: " + cause.getMessage());
                    pluginRealm.display(ps);
                    throw new PluginContainerException(mojoDescriptor, pluginRealm, os.toString(), cause);
                }
                if (cause instanceof LinkageError) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
                    PrintStream ps = new PrintStream(os);
                    ps.println("Unable to load the mojo '" + mojoDescriptor.getGoal() + "' in the plugin '" + pluginDescriptor.getId() + "' due to an API incompatibility: " + ((Object)((Object)e)).getClass().getName() + ": " + cause.getMessage());
                    pluginRealm.display(ps);
                    throw new PluginContainerException(mojoDescriptor, pluginRealm, os.toString(), cause);
                }
                throw new PluginContainerException(mojoDescriptor, pluginRealm, "Unable to load the mojo '" + mojoDescriptor.getGoal() + "' (or one of its required components) from the plugin '" + pluginDescriptor.getId() + "'", e);
            }
            if (mojo instanceof ContextEnabled && (pluginContext = session.getPluginContext(pluginDescriptor, project = session.getCurrentProject())) != null) {
                pluginContext.put("project", project);
                pluginContext.put("pluginDescriptor", pluginDescriptor);
                ((ContextEnabled)mojo).setPluginContext(pluginContext);
            }
            if (mojo instanceof Mojo) {
                ((Mojo)mojo).setLog((Log)new DefaultLog(this.logger));
            }
            XmlPlexusConfiguration pomConfiguration = (dom = mojoExecution.getConfiguration()) == null ? new XmlPlexusConfiguration("configuration") : new XmlPlexusConfiguration(dom);
            PluginParameterExpressionEvaluator expressionEvaluator = new PluginParameterExpressionEvaluator(session, mojoExecution);
            this.populatePluginFields(mojo, mojoDescriptor, pluginRealm, (PlexusConfiguration)pomConfiguration, (ExpressionEvaluator)expressionEvaluator);
            Object object = mojo;
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            this.container.setLookupRealm(oldLookupRealm);
        }
    }

    private synchronized void populatePluginFields(Object mojo, MojoDescriptor mojoDescriptor, ClassRealm pluginRealm, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator) throws PluginConfigurationException {
        ComponentConfigurator configurator = null;
        String configuratorId = mojoDescriptor.getComponentConfigurator();
        if (StringUtils.isEmpty((String)configuratorId)) {
            configuratorId = "basic";
        }
        try {
            configurator = (ComponentConfigurator)this.container.lookup(ComponentConfigurator.class, configuratorId);
            DebugConfigurationListener listener = new DebugConfigurationListener(this.logger);
            this.logger.debug("Configuring mojo '" + mojoDescriptor.getId() + "' with " + configuratorId + " configurator -->");
            configurator.configureComponent(mojo, configuration, expressionEvaluator, pluginRealm, (ConfigurationListener)listener);
            this.logger.debug("-- end configuration --");
        }
        catch (ComponentConfigurationException e) {
            String message = "Unable to parse configuration of mojo " + mojoDescriptor.getId();
            if (e.getFailedConfiguration() != null) {
                message = message + " for parameter " + e.getFailedConfiguration().getName();
            }
            message = message + ": " + e.getMessage();
            throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), message, e);
        }
        catch (ComponentLookupException e) {
            throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), "Unable to retrieve component configurator " + configuratorId + " for configuration of mojo " + mojoDescriptor.getId(), e);
        }
        catch (NoClassDefFoundError e) {
            ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
            PrintStream ps = new PrintStream(os);
            ps.println("A required class was missing during configuration of mojo " + mojoDescriptor.getId() + ": " + e.getMessage());
            pluginRealm.display(ps);
            throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), os.toString(), e);
        }
        catch (LinkageError e) {
            ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
            PrintStream ps = new PrintStream(os);
            ps.println("An API incompatibility was encountered during configuration of mojo " + mojoDescriptor.getId() + ": " + e.getClass().getName() + ": " + e.getMessage());
            pluginRealm.display(ps);
            throw new PluginConfigurationException(mojoDescriptor.getPluginDescriptor(), os.toString(), e);
        }
        finally {
            if (configurator != null) {
                try {
                    this.container.release((Object)configurator);
                }
                catch (ComponentLifecycleException e) {
                    this.logger.debug("Failed to release mojo configurator - ignoring.");
                }
            }
        }
    }

    @Override
    public void releaseMojo(Object mojo, MojoExecution mojoExecution) {
        if (mojo != null) {
            try {
                this.container.release(mojo);
            }
            catch (ComponentLifecycleException e) {
                String goalExecId = mojoExecution.getGoal();
                if (mojoExecution.getExecutionId() != null) {
                    goalExecId = goalExecId + " {execution: " + mojoExecution.getExecutionId() + "}";
                }
                this.logger.debug("Error releasing mojo for " + goalExecId, (Throwable)e);
            }
        }
    }
}

