/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.ArtifactFilterManager;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.internal.PluginDependenciesResolver;
import org.apache.maven.plugin.internal.PluginDependencyResolutionListener;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=PluginDependenciesResolver.class)
public class DefaultPluginDependenciesResolver
implements PluginDependenciesResolver {
    @Requirement
    protected RepositorySystem repositorySystem;
    @Requirement
    private ResolutionErrorHandler resolutionErrorHandler;
    @Requirement
    private ArtifactFilterManager artifactFilterManager;

    @Override
    public Artifact resolve(Plugin plugin, ArtifactResolutionRequest request) throws PluginResolutionException {
        Artifact pluginArtifact = this.repositorySystem.createPluginArtifact(plugin);
        request.setArtifact(pluginArtifact);
        request.setResolveRoot(true);
        request.setResolveTransitively(false);
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        try {
            this.resolutionErrorHandler.throwErrors(request, result);
        }
        catch (ArtifactResolutionException e) {
            throw new PluginResolutionException(plugin, e);
        }
        return pluginArtifact;
    }

    @Override
    public List<Artifact> resolve(Plugin plugin, Artifact pluginArtifact, ArtifactResolutionRequest request, ArtifactFilter dependencyFilter) throws PluginResolutionException {
        if (pluginArtifact == null) {
            pluginArtifact = this.repositorySystem.createPluginArtifact(plugin);
        }
        LinkedHashSet<Artifact> overrideArtifacts = new LinkedHashSet<Artifact>();
        for (Dependency dependency : plugin.getDependencies()) {
            overrideArtifacts.add(this.repositorySystem.createDependencyArtifact(dependency));
        }
        ScopeArtifactFilter collectionFilter = new ScopeArtifactFilter("runtime+system");
        ArtifactFilter resolutionFilter = this.artifactFilterManager.getCoreArtifactFilter();
        PluginDependencyResolutionListener listener = new PluginDependencyResolutionListener(resolutionFilter);
        if (dependencyFilter != null) {
            resolutionFilter = new AndArtifactFilter(Arrays.asList(resolutionFilter, dependencyFilter));
        }
        request.setArtifact(pluginArtifact);
        request.setArtifactDependencies(overrideArtifacts);
        request.setCollectionFilter(collectionFilter);
        request.setResolutionFilter(resolutionFilter);
        request.setResolveRoot(true);
        request.setResolveTransitively(true);
        request.addListener(listener);
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        try {
            this.resolutionErrorHandler.throwErrors(request, result);
        }
        catch (ArtifactResolutionException e) {
            throw new PluginResolutionException(plugin, e);
        }
        ArrayList<Artifact> pluginArtifacts = new ArrayList<Artifact>(result.getArtifacts());
        listener.removeBannedDependencies(pluginArtifacts);
        this.addPlexusUtils(pluginArtifacts, plugin, request);
        return pluginArtifacts;
    }

    private void addPlexusUtils(List<Artifact> pluginArtifacts, Plugin plugin, RepositoryRequest repositoryRequest) throws PluginResolutionException {
        for (Artifact artifact : pluginArtifacts) {
            if (!"org.codehaus.plexus:plexus-utils:jar".equals(artifact.getDependencyConflictId())) continue;
            return;
        }
        Artifact plexusUtils = this.repositorySystem.createArtifact("org.codehaus.plexus", "plexus-utils", "1.1", "runtime", "jar");
        ArtifactResolutionRequest request = new ArtifactResolutionRequest(repositoryRequest);
        request.setArtifact(plexusUtils);
        request.setResolveRoot(true);
        request.setResolveTransitively(false);
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        try {
            this.resolutionErrorHandler.throwErrors(request, result);
        }
        catch (ArtifactResolutionException e) {
            throw new PluginResolutionException(plugin, e);
        }
        pluginArtifacts.add(plexusUtils);
    }
}

