/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import java.util.Map;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultRepositoryRequest;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.prefix.DefaultPluginPrefixRequest;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.prefix.PluginPrefixResolver;
import org.apache.maven.plugin.prefix.PluginPrefixResult;
import org.apache.maven.plugin.version.DefaultPluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionNotFoundException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

@Component(role=PluginManager.class)
public class DefaultPluginManager
implements PluginManager {
    @Requirement
    private PlexusContainer container;
    @Requirement
    private MavenPluginManager pluginManager;
    @Requirement
    private PluginVersionResolver pluginVersionResolver;
    @Requirement
    private PluginPrefixResolver pluginPrefixResolver;
    @Requirement
    private LegacySupport legacySupport;

    public void executeMojo(MavenProject project, MojoExecution execution, MavenSession session) throws MojoExecutionException, ArtifactResolutionException, MojoFailureException, ArtifactNotFoundException, InvalidDependencyVersionException, PluginManagerException, PluginConfigurationException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPluginComponent(Plugin plugin, String role, String roleHint) throws PluginManagerException, ComponentLookupException {
        PluginDescriptor pluginDescriptor;
        MavenSession session = this.legacySupport.getSession();
        try {
            RepositoryRequest repositoryRequest = DefaultRepositoryRequest.getRepositoryRequest(session, session.getCurrentProject());
            pluginDescriptor = this.pluginManager.getPluginDescriptor(plugin, repositoryRequest);
            this.pluginManager.setupPluginRealm(pluginDescriptor, session, null, null, null);
        }
        catch (Exception e) {
            throw new PluginManagerException(plugin, e.getMessage(), (Throwable)e);
        }
        ClassRealm oldRealm = this.container.getLookupRealm();
        try {
            this.container.setLookupRealm(pluginDescriptor.getClassRealm());
            Object object = this.container.lookup(role, roleHint);
            return object;
        }
        finally {
            this.container.setLookupRealm(oldRealm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getPluginComponents(Plugin plugin, String role) throws ComponentLookupException, PluginManagerException {
        PluginDescriptor pluginDescriptor;
        MavenSession session = this.legacySupport.getSession();
        try {
            RepositoryRequest repositoryRequest = DefaultRepositoryRequest.getRepositoryRequest(session, session.getCurrentProject());
            pluginDescriptor = this.pluginManager.getPluginDescriptor(plugin, repositoryRequest);
            this.pluginManager.setupPluginRealm(pluginDescriptor, session, null, null, null);
        }
        catch (Exception e) {
            throw new PluginManagerException(plugin, e.getMessage(), (Throwable)e);
        }
        ClassRealm oldRealm = this.container.getLookupRealm();
        try {
            this.container.setLookupRealm(pluginDescriptor.getClassRealm());
            Map map = this.container.lookupMap(role);
            return map;
        }
        finally {
            this.container.setLookupRealm(oldRealm);
        }
    }

    public Plugin getPluginDefinitionForPrefix(String prefix, MavenSession session, MavenProject project) {
        DefaultPluginPrefixRequest request = new DefaultPluginPrefixRequest(prefix, session);
        request.setPom(project.getModel());
        try {
            PluginPrefixResult result = this.pluginPrefixResolver.resolve(request);
            Plugin plugin = new Plugin();
            plugin.setGroupId(result.getGroupId());
            plugin.setArtifactId(result.getArtifactId());
            return plugin;
        }
        catch (NoPluginFoundForPrefixException e) {
            return null;
        }
    }

    public PluginDescriptor getPluginDescriptorForPrefix(String prefix) {
        MavenSession session = this.legacySupport.getSession();
        DefaultPluginPrefixRequest request = new DefaultPluginPrefixRequest(prefix, session);
        try {
            PluginPrefixResult result = this.pluginPrefixResolver.resolve(request);
            Plugin plugin = new Plugin();
            plugin.setGroupId(result.getGroupId());
            plugin.setArtifactId(result.getArtifactId());
            return this.loadPluginDescriptor(plugin, session.getCurrentProject(), session);
        }
        catch (Exception e) {
            return null;
        }
    }

    public PluginDescriptor loadPluginDescriptor(Plugin plugin, MavenProject project, MavenSession session) throws ArtifactResolutionException, PluginVersionResolutionException, ArtifactNotFoundException, InvalidVersionSpecificationException, InvalidPluginException, PluginManagerException, PluginNotFoundException, PluginVersionNotFoundException {
        return this.verifyPlugin(plugin, project, session.getSettings(), session.getLocalRepository());
    }

    public PluginDescriptor loadPluginFully(Plugin plugin, MavenProject project, MavenSession session) throws ArtifactResolutionException, PluginVersionResolutionException, ArtifactNotFoundException, InvalidVersionSpecificationException, InvalidPluginException, PluginManagerException, PluginNotFoundException, PluginVersionNotFoundException {
        PluginDescriptor pluginDescriptor = this.loadPluginDescriptor(plugin, project, session);
        try {
            this.pluginManager.setupPluginRealm(pluginDescriptor, session, null, null, null);
        }
        catch (PluginResolutionException e) {
            throw new PluginManagerException(plugin, e.getMessage(), (Throwable)((Object)e));
        }
        return pluginDescriptor;
    }

    public PluginDescriptor verifyPlugin(Plugin plugin, MavenProject project, Settings settings, ArtifactRepository localRepository) throws ArtifactResolutionException, PluginVersionResolutionException, ArtifactNotFoundException, InvalidVersionSpecificationException, InvalidPluginException, PluginManagerException, PluginNotFoundException, PluginVersionNotFoundException {
        DefaultRepositoryRequest repositoryRequest = new DefaultRepositoryRequest();
        repositoryRequest.setLocalRepository(localRepository);
        repositoryRequest.setRemoteRepositories(project.getPluginArtifactRepositories());
        repositoryRequest.setOffline(settings.isOffline());
        if (plugin.getVersion() == null) {
            DefaultPluginVersionRequest versionRequest = new DefaultPluginVersionRequest(plugin, repositoryRequest);
            plugin.setVersion(this.pluginVersionResolver.resolve(versionRequest).getVersion());
        }
        try {
            return this.pluginManager.getPluginDescriptor(plugin, repositoryRequest);
        }
        catch (PluginResolutionException e) {
            throw new PluginNotFoundException(plugin, repositoryRequest.getRemoteRepositories());
        }
        catch (PluginDescriptorParsingException e) {
            throw new PluginManagerException(plugin, e.getMessage(), (Throwable)e);
        }
        catch (InvalidPluginDescriptorException e) {
            throw new PluginManagerException(plugin, e.getMessage(), (Throwable)e);
        }
    }
}

