/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.prefix;

import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoPluginFoundForPrefixException
extends Exception {
    private String prefix;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteRepositories;

    public NoPluginFoundForPrefixException(String prefix, List<String> pluginGroups, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) {
        super("No plugin found for prefix '" + prefix + "' in the current project and in the plugin groups " + pluginGroups + " available from the repositories " + NoPluginFoundForPrefixException.format(localRepository, remoteRepositories));
        this.prefix = prefix;
        this.localRepository = localRepository;
        this.remoteRepositories = remoteRepositories;
    }

    private static String format(ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) {
        String repos = "[";
        if (localRepository != null) {
            repos = repos + localRepository.getId() + " (" + localRepository.getBasedir() + ")";
        }
        if (remoteRepositories != null && !remoteRepositories.isEmpty()) {
            for (ArtifactRepository repository : remoteRepositories) {
                repos = repos + ", ";
                if (repository == null) continue;
                repos = repos + repository.getId() + " (" + repository.getUrl() + ")";
            }
        }
        repos = repos + "]";
        return repos;
    }
}

