/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.prefix.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.io.MetadataReader;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.prefix.PluginPrefixRequest;
import org.apache.maven.plugin.prefix.PluginPrefixResolver;
import org.apache.maven.plugin.prefix.PluginPrefixResult;
import org.apache.maven.plugin.prefix.internal.DefaultPluginPrefixResult;
import org.apache.maven.repository.ArtifactDoesNotExistException;
import org.apache.maven.repository.ArtifactTransferFailedException;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=PluginPrefixResolver.class)
public class DefaultPluginPrefixResolver
implements PluginPrefixResolver {
    @Requirement
    private Logger logger;
    @Requirement
    private BuildPluginManager pluginManager;
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private MetadataReader metadataReader;

    @Override
    public PluginPrefixResult resolve(PluginPrefixRequest request) throws NoPluginFoundForPrefixException {
        this.logger.debug("Resolving plugin prefix " + request.getPrefix() + " from " + request.getPluginGroups());
        PluginPrefixResult result = this.resolveFromProject(request);
        if (result == null) {
            result = this.resolveFromRepository(request);
            if (result == null) {
                throw new NoPluginFoundForPrefixException(request.getPrefix(), request.getPluginGroups(), request.getLocalRepository(), request.getRemoteRepositories());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Resolved plugin prefix " + request.getPrefix() + " to " + result.getGroupId() + ":" + result.getArtifactId() + " from repository " + (result.getRepository() != null ? result.getRepository().getId() : "null"));
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Resolved plugin prefix " + request.getPrefix() + " to " + result.getGroupId() + ":" + result.getArtifactId() + " from POM " + request.getPom());
        }
        return result;
    }

    private PluginPrefixResult resolveFromProject(PluginPrefixRequest request) {
        Build build;
        PluginPrefixResult result = null;
        if (request.getPom() != null && request.getPom().getBuild() != null && (result = this.resolveFromProject(request, (build = request.getPom().getBuild()).getPlugins())) == null && build.getPluginManagement() != null) {
            result = this.resolveFromProject(request, build.getPluginManagement().getPlugins());
        }
        return result;
    }

    private PluginPrefixResult resolveFromProject(PluginPrefixRequest request, List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            try {
                PluginDescriptor pluginDescriptor = this.pluginManager.loadPlugin(plugin, request);
                if (!request.getPrefix().equals(pluginDescriptor.getGoalPrefix())) continue;
                return new DefaultPluginPrefixResult(plugin);
            }
            catch (Exception e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn("Failed to retrieve plugin descriptor for " + plugin.getId() + ": " + e.getMessage(), (Throwable)e);
                    continue;
                }
                this.logger.warn("Failed to retrieve plugin descriptor for " + plugin.getId() + ": " + e.getMessage());
            }
        }
        return null;
    }

    private PluginPrefixResult resolveFromRepository(PluginPrefixRequest request) {
        ArtifactRepository localRepository = request.getLocalRepository();
        for (String pluginGroup : request.getPluginGroups()) {
            String localPath = this.getLocalMetadataPath(pluginGroup, localRepository);
            File groupMetadataFile = new File(localRepository.getBasedir(), localPath);
            PluginPrefixResult result = this.resolveFromRepository(request, pluginGroup, groupMetadataFile, localRepository);
            if (result == null) continue;
            return result;
        }
        HashMap<String, ArrayList<ArtifactRepository>> recheck = new HashMap<String, ArrayList<ArtifactRepository>>();
        for (String pluginGroup : request.getPluginGroups()) {
            for (ArtifactRepository repository : request.getRemoteRepositories()) {
                PluginPrefixResult result;
                File groupMetadataFile;
                block18: {
                    String localPath = this.getLocalMetadataPath(pluginGroup, repository);
                    groupMetadataFile = new File(localRepository.getBasedir(), localPath);
                    if (!(request.isOffline() || groupMetadataFile.exists() && !request.isForceUpdate())) {
                        String remotePath = this.getRemoteMetadataPath(pluginGroup, repository);
                        try {
                            this.repositorySystem.retrieve(repository, groupMetadataFile, remotePath, request.getTransferListener());
                            break block18;
                        }
                        catch (ArtifactTransferFailedException e) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.warn("Failed to retrieve " + remotePath + " from " + repository.getId() + ": " + e.getMessage(), (Throwable)e);
                            } else {
                                this.logger.warn("Failed to retrieve " + remotePath + " from " + repository.getId() + ": " + e.getMessage());
                            }
                            break block18;
                        }
                        catch (ArtifactDoesNotExistException e) {
                            continue;
                        }
                    }
                    if (!request.isOffline() && !request.isForceUpdate()) {
                        ArrayList<ArtifactRepository> repos = (ArrayList<ArtifactRepository>)recheck.get(pluginGroup);
                        if (repos == null) {
                            repos = new ArrayList<ArtifactRepository>();
                            recheck.put(pluginGroup, repos);
                        }
                        repos.add(repository);
                    }
                }
                if ((result = this.resolveFromRepository(request, pluginGroup, groupMetadataFile, repository)) == null) continue;
                return result;
            }
        }
        for (String pluginGroup : request.getPluginGroups()) {
            List repos = (List)recheck.get(pluginGroup);
            if (repos == null) continue;
            for (ArtifactRepository repository : repos) {
                PluginPrefixResult result;
                String localPath = this.getLocalMetadataPath(pluginGroup, repository);
                File groupMetadataFile = new File(localRepository.getBasedir(), localPath);
                String remotePath = this.getRemoteMetadataPath(pluginGroup, repository);
                try {
                    this.repositorySystem.retrieve(repository, groupMetadataFile, remotePath, request.getTransferListener());
                }
                catch (ArtifactTransferFailedException e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.warn("Failed to retrieve " + remotePath + " from " + repository.getId() + ": " + e.getMessage(), (Throwable)e);
                    } else {
                        this.logger.warn("Failed to retrieve " + remotePath + " from " + repository.getId() + ": " + e.getMessage());
                    }
                }
                catch (ArtifactDoesNotExistException e) {
                    continue;
                }
                if ((result = this.resolveFromRepository(request, pluginGroup, groupMetadataFile, repository)) == null) continue;
                return result;
            }
        }
        return null;
    }

    private PluginPrefixResult resolveFromRepository(PluginPrefixRequest request, String pluginGroup, File metadataFile, ArtifactRepository repository) {
        if (metadataFile.isFile()) {
            try {
                Map<String, Boolean> options = Collections.singletonMap("org.apache.maven.artifact.repository.metadata.io.isStrict", Boolean.FALSE);
                Metadata pluginGroupMetadata = this.metadataReader.read(metadataFile, options);
                List<org.apache.maven.artifact.repository.metadata.Plugin> plugins = pluginGroupMetadata.getPlugins();
                if (plugins != null) {
                    for (org.apache.maven.artifact.repository.metadata.Plugin plugin : plugins) {
                        if (!request.getPrefix().equals(plugin.getPrefix())) continue;
                        return new DefaultPluginPrefixResult(pluginGroup, plugin.getArtifactId(), repository);
                    }
                }
            }
            catch (IOException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn("Error reading plugin group metadata: " + e.getMessage(), (Throwable)e);
                }
                this.logger.warn("Error reading plugin group metadata: " + e.getMessage());
            }
        }
        return null;
    }

    private String getLocalMetadataPath(String groupId, ArtifactRepository repository) {
        return groupId.replace('.', '/') + "/" + "maven-metadata-" + repository.getId() + ".xml";
    }

    private String getRemoteMetadataPath(String groupId, ArtifactRepository repository) {
        return groupId.replace('.', '/') + "/" + "maven-metadata.xml";
    }
}

