/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.version;

import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultRepositoryRequest;
import org.apache.maven.artifact.repository.RepositoryCache;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.version.PluginVersionRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.ArtifactTransferListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginVersionRequest
implements PluginVersionRequest {
    private String groupId;
    private String artifactId;
    private Model pom;
    private RepositoryRequest repositoryRequest;

    public DefaultPluginVersionRequest() {
        this.repositoryRequest = new DefaultRepositoryRequest();
    }

    public DefaultPluginVersionRequest(RepositoryRequest repositoryRequest) {
        this.repositoryRequest = new DefaultRepositoryRequest(repositoryRequest);
    }

    public DefaultPluginVersionRequest(Plugin plugin, RepositoryRequest repositoryRequest) {
        this.groupId = plugin.getGroupId();
        this.artifactId = plugin.getArtifactId();
        this.repositoryRequest = new DefaultRepositoryRequest(repositoryRequest);
    }

    public DefaultPluginVersionRequest(Plugin plugin, MavenSession session) {
        this.groupId = plugin.getGroupId();
        this.artifactId = plugin.getArtifactId();
        this.repositoryRequest = new DefaultRepositoryRequest();
        this.setCache(session.getRepositoryCache());
        this.setLocalRepository(session.getLocalRepository());
        this.setOffline(session.isOffline());
        this.setForceUpdate(session.getRequest().isUpdateSnapshots());
        this.setTransferListener(session.getRequest().getTransferListener());
        MavenProject project = session.getCurrentProject();
        if (project != null) {
            this.setRemoteRepositories((List)project.getPluginArtifactRepositories());
        }
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public DefaultPluginVersionRequest setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public DefaultPluginVersionRequest setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    @Override
    public Model getPom() {
        return this.pom;
    }

    @Override
    public DefaultPluginVersionRequest setPom(Model pom) {
        this.pom = pom;
        return this;
    }

    @Override
    public RepositoryCache getCache() {
        return this.repositoryRequest.getCache();
    }

    @Override
    public DefaultPluginVersionRequest setCache(RepositoryCache cache) {
        this.repositoryRequest.setCache(cache);
        return this;
    }

    @Override
    public ArtifactRepository getLocalRepository() {
        return this.repositoryRequest.getLocalRepository();
    }

    @Override
    public DefaultPluginVersionRequest setLocalRepository(ArtifactRepository localRepository) {
        this.repositoryRequest.setLocalRepository(localRepository);
        return this;
    }

    @Override
    public List<ArtifactRepository> getRemoteRepositories() {
        return this.repositoryRequest.getRemoteRepositories();
    }

    @Override
    public DefaultPluginVersionRequest setRemoteRepositories(List<ArtifactRepository> remoteRepositories) {
        this.repositoryRequest.setRemoteRepositories(remoteRepositories);
        return this;
    }

    @Override
    public boolean isOffline() {
        return this.repositoryRequest.isOffline();
    }

    @Override
    public DefaultPluginVersionRequest setOffline(boolean offline) {
        this.repositoryRequest.setOffline(offline);
        return this;
    }

    @Override
    public boolean isForceUpdate() {
        return this.repositoryRequest.isForceUpdate();
    }

    @Override
    public DefaultPluginVersionRequest setForceUpdate(boolean forceUpdate) {
        this.repositoryRequest.setForceUpdate(forceUpdate);
        return this;
    }

    @Override
    public ArtifactTransferListener getTransferListener() {
        return this.repositoryRequest.getTransferListener();
    }

    @Override
    public DefaultPluginVersionRequest setTransferListener(ArtifactTransferListener transferListener) {
        this.repositoryRequest.setTransferListener(transferListener);
        return this;
    }
}

