/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.DefaultModelProblem;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingListener;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelCache;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.StringModelSource;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.project.DefaultModelBuildingListener;
import org.apache.maven.project.DefaultProjectBuildingResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingHelper;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ReactorModelCache;
import org.apache.maven.project.ReactorModelPool;
import org.apache.maven.project.RepositoryModelResolver;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ProjectBuilder.class)
public class DefaultProjectBuilder
implements ProjectBuilder {
    @Requirement
    private ModelBuilder modelBuilder;
    @Requirement
    private ModelProcessor modelProcessor;
    @Requirement
    private ProjectBuildingHelper projectBuildingHelper;
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private ResolutionErrorHandler resolutionErrorHandler;

    @Override
    public ProjectBuildingResult build(File pomFile, ProjectBuildingRequest configuration) throws ProjectBuildingException {
        return this.build(pomFile, (ModelSource)new FileModelSource(pomFile), configuration);
    }

    @Override
    public ProjectBuildingResult build(ModelSource modelSource, ProjectBuildingRequest configuration) throws ProjectBuildingException {
        return this.build(null, modelSource, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectBuildingResult build(File pomFile, ModelSource modelSource, ProjectBuildingRequest configuration) throws ProjectBuildingException {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            MavenProject project = configuration.getProject();
            List modelProblems = null;
            if (project == null) {
                ModelBuildingResult result;
                ModelBuildingRequest request = this.getModelBuildingRequest(configuration, null);
                project = new MavenProject(this.repositorySystem, this, configuration);
                DefaultModelBuildingListener listener = new DefaultModelBuildingListener(project, this.projectBuildingHelper, configuration);
                request.setModelBuildingListener((ModelBuildingListener)listener);
                request.setPomFile(pomFile);
                request.setModelSource(modelSource);
                try {
                    result = this.modelBuilder.build(request);
                }
                catch (ModelBuildingException e) {
                    throw new ProjectBuildingException(e.getModelId(), e.getMessage(), pomFile, e);
                }
                modelProblems = result.getProblems();
                this.initProject(project, result);
            } else if (configuration.isResolveDependencies()) {
                this.projectBuildingHelper.selectProjectRealm(project);
            }
            ArtifactResolutionResult artifactResult = null;
            if (configuration.isResolveDependencies()) {
                ProjectArtifact artifact = new ProjectArtifact(project);
                ArtifactResolutionRequest artifactRequest = ((ArtifactResolutionRequest)new ArtifactResolutionRequest().setArtifact((Artifact)artifact).setResolveRoot(false).setResolveTransitively(true).setCache(configuration.getRepositoryCache()).setLocalRepository(configuration.getLocalRepository()).setRemoteRepositories((List)project.getRemoteArtifactRepositories())).setServers(configuration.getServers()).setMirrors(configuration.getMirrors()).setProxies(configuration.getProxies()).setOffline(configuration.isOffline()).setForceUpdate(configuration.isForceUpdate()).setManagedVersionMap(project.getManagedVersionMap());
                artifactRequest.setTransferListener(configuration.getTransferListener());
                artifactResult = this.repositorySystem.resolve(artifactRequest);
                project.setResolvedArtifacts(artifactResult.getArtifacts());
                project.setArtifacts(artifactResult.getArtifacts());
            }
            DefaultProjectBuildingResult defaultProjectBuildingResult = new DefaultProjectBuildingResult(project, modelProblems, artifactResult);
            return defaultProjectBuildingResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    private List<String> getProfileIds(List<Profile> profiles) {
        ArrayList<String> ids = new ArrayList<String>(profiles.size());
        for (Profile profile : profiles) {
            ids.add(profile.getId());
        }
        return ids;
    }

    private ModelBuildingRequest getModelBuildingRequest(ProjectBuildingRequest configuration, ReactorModelPool reactorModelPool) {
        RepositoryModelResolver resolver = new RepositoryModelResolver(this.repositorySystem, this.resolutionErrorHandler, configuration, reactorModelPool);
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
        request.setValidationLevel(configuration.getValidationLevel());
        request.setProcessPlugins(configuration.isProcessPlugins());
        request.setProfiles(configuration.getProfiles());
        request.setActiveProfileIds(configuration.getActiveProfileIds());
        request.setInactiveProfileIds(configuration.getInactiveProfileIds());
        request.setSystemProperties(configuration.getSystemProperties());
        request.setUserProperties(configuration.getUserProperties());
        request.setBuildStartTime(configuration.getBuildStartTime());
        request.setModelResolver((ModelResolver)resolver);
        return request;
    }

    @Override
    public ProjectBuildingResult build(Artifact artifact, ProjectBuildingRequest configuration) throws ProjectBuildingException {
        return this.build(artifact, false, configuration);
    }

    @Override
    public ProjectBuildingResult build(Artifact artifact, boolean allowStubModel, ProjectBuildingRequest configuration) throws ProjectBuildingException {
        if (!artifact.getType().equals("pom")) {
            artifact = this.repositorySystem.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        }
        ArtifactResolutionRequest request = ((ArtifactResolutionRequest)new ArtifactResolutionRequest().setArtifact(artifact).setCache(configuration.getRepositoryCache()).setLocalRepository(configuration.getLocalRepository()).setRemoteRepositories((List)configuration.getRemoteRepositories())).setOffline(configuration.isOffline()).setForceUpdate(configuration.isForceUpdate());
        request.setTransferListener(configuration.getTransferListener());
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        if (result.hasMissingArtifacts() && allowStubModel) {
            return this.build(null, this.createStubModelSource(artifact), configuration);
        }
        try {
            this.resolutionErrorHandler.throwErrors(request, result);
        }
        catch (ArtifactResolutionException e) {
            throw new ProjectBuildingException(artifact.getId(), "Error resolving project artifact: " + e.getMessage(), e);
        }
        boolean localProject = artifact.getRepository() != null && artifact.getRepository().isProjectAware();
        File pomFile = artifact.getFile();
        return this.build(localProject ? pomFile : null, (ModelSource)new FileModelSource(pomFile), configuration);
    }

    private ModelSource createStubModelSource(Artifact artifact) {
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append("<?xml version='1.0'?>");
        buffer.append("<project>");
        buffer.append("<modelVersion>4.0.0</modelVersion>");
        buffer.append("<groupId>").append(artifact.getGroupId()).append("</groupId>");
        buffer.append("<artifactId>").append(artifact.getArtifactId()).append("</artifactId>");
        buffer.append("<version>").append(artifact.getBaseVersion()).append("</version>");
        buffer.append("<packaging>").append(artifact.getType()).append("</packaging>");
        buffer.append("</project>");
        return new StringModelSource((CharSequence)buffer, artifact.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProjectBuildingResult> build(List<File> pomFiles, boolean recursive, ProjectBuildingRequest config) throws ProjectBuildingException {
        ArrayList<ProjectBuildingResult> results = new ArrayList<ProjectBuildingResult>();
        ArrayList<InterimResult> interimResults = new ArrayList<InterimResult>();
        ReactorModelPool reactorModelPool = new ReactorModelPool();
        ReactorModelCache modelCache = new ReactorModelCache();
        boolean noErrors = this.build(results, interimResults, pomFiles, true, recursive, config, reactorModelPool, modelCache);
        this.populateReactorModelPool(reactorModelPool, interimResults);
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            noErrors = this.build(results, new ArrayList<MavenProject>(), interimResults, config) && noErrors;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
        if (!noErrors) {
            throw new ProjectBuildingException(results);
        }
        return results;
    }

    private boolean build(List<ProjectBuildingResult> results, List<InterimResult> interimResults, List<File> pomFiles, boolean isRoot, boolean recursive, ProjectBuildingRequest config, ReactorModelPool reactorModelPool, ReactorModelCache modelCache) {
        boolean noErrors = true;
        for (File pomFile : pomFiles) {
            ModelBuildingRequest request = this.getModelBuildingRequest(config, reactorModelPool);
            MavenProject project = new MavenProject(this.repositorySystem, this, config);
            request.setPomFile(pomFile);
            request.setTwoPhaseBuilding(true);
            request.setModelCache((ModelCache)modelCache);
            DefaultModelBuildingListener listener = new DefaultModelBuildingListener(project, this.projectBuildingHelper, config);
            request.setModelBuildingListener((ModelBuildingListener)listener);
            try {
                ModelBuildingResult result = this.modelBuilder.build(request);
                Model model = result.getEffectiveModel();
                InterimResult interimResult = new InterimResult(pomFile, request, result, listener, isRoot);
                interimResults.add(interimResult);
                if (!recursive || model.getModules().isEmpty()) continue;
                File basedir = pomFile.getParentFile();
                ArrayList<File> moduleFiles = new ArrayList<File>();
                for (String module : model.getModules()) {
                    if (StringUtils.isEmpty((String)module)) continue;
                    File moduleFile = new File(basedir, module = module.replace('\\', File.separatorChar).replace('/', File.separatorChar));
                    if (moduleFile.isDirectory()) {
                        moduleFile = this.modelProcessor.locatePom(moduleFile);
                    }
                    if (!moduleFile.isFile()) {
                        DefaultModelProblem problem = new DefaultModelProblem("Child module " + moduleFile + " of " + pomFile + " does not exist", ModelProblem.Severity.ERROR, model, -1, -1, null);
                        result.getProblems().add(problem);
                        noErrors = false;
                        continue;
                    }
                    if (Os.isFamily((String)"windows")) {
                        try {
                            moduleFile = moduleFile.getCanonicalFile();
                        }
                        catch (IOException e) {
                            moduleFile = moduleFile.getAbsoluteFile();
                        }
                    } else {
                        moduleFile = new File(moduleFile.toURI().normalize());
                    }
                    moduleFiles.add(moduleFile);
                }
                interimResult.modules = new ArrayList<InterimResult>();
                if (this.build(results, interimResult.modules, moduleFiles, false, recursive, config, reactorModelPool, modelCache)) continue;
                noErrors = false;
            }
            catch (ModelBuildingException e) {
                results.add(new DefaultProjectBuildingResult(e.getModelId(), pomFile, e.getProblems()));
                noErrors = false;
            }
        }
        return noErrors;
    }

    private void populateReactorModelPool(ReactorModelPool reactorModelPool, List<InterimResult> interimResults) {
        for (InterimResult interimResult : interimResults) {
            Model model = interimResult.result.getEffectiveModel();
            reactorModelPool.put(model.getGroupId(), model.getArtifactId(), model.getVersion(), model.getPomFile());
            this.populateReactorModelPool(reactorModelPool, interimResult.modules);
        }
    }

    private boolean build(List<ProjectBuildingResult> results, List<MavenProject> projects, List<InterimResult> interimResults, ProjectBuildingRequest config) {
        boolean noErrors = true;
        for (InterimResult interimResult : interimResults) {
            try {
                ModelBuildingResult result = this.modelBuilder.build(interimResult.request, interimResult.result);
                MavenProject project = interimResult.listener.getProject();
                this.initProject(project, result);
                ArrayList<MavenProject> modules = new ArrayList<MavenProject>();
                noErrors = this.build(results, modules, interimResult.modules, config) && noErrors;
                projects.addAll(modules);
                projects.add(project);
                project.setExecutionRoot(interimResult.root);
                project.setCollectedProjects(modules);
                results.add(new DefaultProjectBuildingResult(project, result.getProblems(), null));
            }
            catch (ModelBuildingException e) {
                results.add(new DefaultProjectBuildingResult(e.getModelId(), interimResult.pomFile, e.getProblems()));
                noErrors = false;
            }
        }
        return noErrors;
    }

    private void initProject(MavenProject project, ModelBuildingResult result) {
        Model model = result.getEffectiveModel();
        project.setModel(model);
        project.setOriginalModel(result.getRawModel());
        project.setFile(model.getPomFile());
        File parentPomFile = result.getRawModel((String)result.getModelIds().get(1)).getPomFile();
        project.setParentFile(parentPomFile);
        Artifact projectArtifact = this.repositorySystem.createArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), null, project.getPackaging());
        project.setArtifact(projectArtifact);
        if (project.getFile() != null) {
            Build build = project.getBuild();
            project.addScriptSourceRoot(build.getScriptSourceDirectory());
            project.addCompileSourceRoot(build.getSourceDirectory());
            project.addTestCompileSourceRoot(build.getTestSourceDirectory());
        }
        ArrayList<Profile> activeProfiles = new ArrayList<Profile>();
        activeProfiles.addAll(result.getActivePomProfiles((String)result.getModelIds().get(0)));
        activeProfiles.addAll(result.getActiveExternalProfiles());
        project.setActiveProfiles(activeProfiles);
        project.setInjectedProfileIds("external", this.getProfileIds(result.getActiveExternalProfiles()));
        for (String modelId : result.getModelIds()) {
            project.setInjectedProfileIds(modelId, this.getProfileIds(result.getActivePomProfiles(modelId)));
        }
    }

    static class InterimResult {
        File pomFile;
        ModelBuildingRequest request;
        ModelBuildingResult result;
        DefaultModelBuildingListener listener;
        boolean root;
        List<InterimResult> modules = Collections.emptyList();

        InterimResult(File pomFile, ModelBuildingRequest request, ModelBuildingResult result, DefaultModelBuildingListener listener, boolean root) {
            this.pomFile = pomFile;
            this.request = request;
            this.result = result;
            this.listener = listener;
            this.root = root;
        }
    }
}

