/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.RepositoryCache;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelEventListener;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.ArtifactTransferListener;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProjectBuildingRequest
implements ProjectBuildingRequest {
    private boolean offline;
    private boolean forceUpdate;
    private RepositoryCache repositoryCache;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteRepositories;
    private List<ArtifactRepository> pluginArtifactRepositories;
    private List<Server> servers;
    private List<Mirror> mirrors;
    private List<Proxy> proxies;
    private List<ModelEventListener> listeners;
    private MavenProject project;
    private int validationLevel = 30;
    private boolean processPlugins = true;
    private List<Profile> profiles = new ArrayList<Profile>();
    private List<String> activeProfileIds = new ArrayList<String>();
    private List<String> inactiveProfileIds = new ArrayList<String>();
    private Properties systemProperties = new Properties();
    private Properties userProperties = new Properties();
    private Date buildStartTime;
    private boolean resolveDependencies;
    private ArtifactTransferListener transferListener;

    public DefaultProjectBuildingRequest() {
        this.remoteRepositories = new ArrayList<ArtifactRepository>();
        this.pluginArtifactRepositories = new ArrayList<ArtifactRepository>();
        this.servers = new ArrayList<Server>();
        this.mirrors = new ArrayList<Mirror>();
        this.proxies = new ArrayList<Proxy>();
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public void setProject(MavenProject mavenProject) {
        this.project = mavenProject;
    }

    @Override
    public DefaultProjectBuildingRequest setOffline(boolean offline) {
        this.offline = offline;
        return this;
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    @Override
    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    @Override
    public ProjectBuildingRequest setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
        return this;
    }

    @Override
    public ProjectBuildingRequest setRepositoryCache(RepositoryCache repositoryCache) {
        this.repositoryCache = repositoryCache;
        return this;
    }

    @Override
    public RepositoryCache getRepositoryCache() {
        return this.repositoryCache;
    }

    @Override
    public ProjectBuildingRequest setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
        return this;
    }

    @Override
    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    @Override
    public List<ArtifactRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    @Override
    public ProjectBuildingRequest setRemoteRepositories(List<ArtifactRepository> remoteRepositories) {
        if (remoteRepositories != null) {
            this.remoteRepositories = new ArrayList<ArtifactRepository>(remoteRepositories);
        } else {
            this.remoteRepositories.clear();
        }
        return this;
    }

    @Override
    public List<ArtifactRepository> getPluginArtifactRepositories() {
        return this.pluginArtifactRepositories;
    }

    @Override
    public ProjectBuildingRequest setPluginArtifactRepositories(List<ArtifactRepository> pluginArtifactRepositories) {
        if (pluginArtifactRepositories != null) {
            this.pluginArtifactRepositories = new ArrayList<ArtifactRepository>(pluginArtifactRepositories);
        } else {
            this.pluginArtifactRepositories.clear();
        }
        return this;
    }

    @Override
    public ProjectBuildingRequest setServers(List<Server> servers) {
        if (servers != null) {
            this.servers = new ArrayList<Server>(servers);
        } else {
            this.servers.clear();
        }
        return this;
    }

    @Override
    public List<Server> getServers() {
        return this.servers;
    }

    @Override
    public ProjectBuildingRequest setMirrors(List<Mirror> mirrors) {
        if (mirrors != null) {
            this.mirrors = new ArrayList<Mirror>(mirrors);
        } else {
            this.mirrors.clear();
        }
        return this;
    }

    @Override
    public List<Mirror> getMirrors() {
        return this.mirrors;
    }

    @Override
    public ProjectBuildingRequest setProxies(List<Proxy> proxies) {
        if (proxies != null) {
            this.proxies = new ArrayList<Proxy>(proxies);
        } else {
            this.proxies.clear();
        }
        return this;
    }

    @Override
    public List<Proxy> getProxies() {
        return this.proxies;
    }

    @Override
    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public ProjectBuildingRequest setSystemProperties(Properties systemProperties) {
        if (systemProperties != null) {
            this.systemProperties = new Properties();
            this.systemProperties.putAll((Map<?, ?>)systemProperties);
        } else {
            this.systemProperties.clear();
        }
        return this;
    }

    @Override
    public Properties getUserProperties() {
        return this.userProperties;
    }

    @Override
    public ProjectBuildingRequest setUserProperties(Properties userProperties) {
        if (userProperties != null) {
            this.userProperties = new Properties();
            this.userProperties.putAll((Map<?, ?>)userProperties);
        } else {
            this.userProperties.clear();
        }
        return this;
    }

    public List<ModelEventListener> getModelEventListeners() {
        return this.listeners;
    }

    public ProjectBuildingRequest setModelEventListeners(List<ModelEventListener> listeners) {
        this.listeners = listeners;
        return this;
    }

    @Override
    public boolean isProcessPlugins() {
        return this.processPlugins;
    }

    @Override
    public ProjectBuildingRequest setProcessPlugins(boolean processPlugins) {
        this.processPlugins = processPlugins;
        return this;
    }

    @Override
    public ProjectBuildingRequest setResolveDependencies(boolean resolveDependencies) {
        this.resolveDependencies = resolveDependencies;
        return this;
    }

    @Override
    public boolean isResolveDependencies() {
        return this.resolveDependencies;
    }

    @Override
    public ProjectBuildingRequest setValidationLevel(int validationLevel) {
        this.validationLevel = validationLevel;
        return this;
    }

    @Override
    public int getValidationLevel() {
        return this.validationLevel;
    }

    @Override
    public List<String> getActiveProfileIds() {
        return this.activeProfileIds;
    }

    @Override
    public void setActiveProfileIds(List<String> activeProfileIds) {
        if (activeProfileIds != null) {
            this.activeProfileIds = new ArrayList<String>(activeProfileIds);
        } else {
            this.activeProfileIds.clear();
        }
    }

    @Override
    public List<String> getInactiveProfileIds() {
        return this.inactiveProfileIds;
    }

    @Override
    public void setInactiveProfileIds(List<String> inactiveProfileIds) {
        if (inactiveProfileIds != null) {
            this.inactiveProfileIds = new ArrayList<String>(inactiveProfileIds);
        } else {
            this.inactiveProfileIds.clear();
        }
    }

    @Override
    public void setProfiles(List<Profile> profiles) {
        if (profiles != null) {
            this.profiles = new ArrayList<Profile>(profiles);
        } else {
            this.profiles.clear();
        }
    }

    @Override
    public void addProfile(Profile profile) {
        this.profiles.add(profile);
    }

    @Override
    public List<Profile> getProfiles() {
        return this.profiles;
    }

    @Override
    public Date getBuildStartTime() {
        return this.buildStartTime;
    }

    @Override
    public void setBuildStartTime(Date buildStartTime) {
        this.buildStartTime = buildStartTime;
    }

    @Override
    public ArtifactTransferListener getTransferListener() {
        return this.transferListener;
    }

    @Override
    public void setTransferListener(ArtifactTransferListener transferListener) {
        this.transferListener = transferListener;
    }
}

