/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectRealmCache;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ProjectRealmCache.class)
public class DefaultProjectRealmCache
implements ProjectRealmCache {
    private final Map<CacheKey, ProjectRealmCache.CacheRecord> cache = new HashMap<CacheKey, ProjectRealmCache.CacheRecord>();

    @Override
    public ProjectRealmCache.CacheRecord get(List<? extends ClassRealm> extensionRealms) {
        return this.cache.get(new CacheKey(extensionRealms));
    }

    @Override
    public ProjectRealmCache.CacheRecord put(List<? extends ClassRealm> extensionRealms, ClassRealm projectRealm, ArtifactFilter extensionArtifactFilter) {
        if (projectRealm == null) {
            throw new NullPointerException();
        }
        CacheKey key = new CacheKey(extensionRealms);
        if (this.cache.containsKey(key)) {
            throw new IllegalStateException("Duplicate project realm for extensions " + extensionRealms);
        }
        ProjectRealmCache.CacheRecord record = new ProjectRealmCache.CacheRecord(projectRealm, extensionArtifactFilter);
        this.cache.put(key, record);
        return record;
    }

    @Override
    public void flush() {
        this.cache.clear();
    }

    @Override
    public void register(MavenProject project, ProjectRealmCache.CacheRecord record) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheKey {
        private final List<? extends ClassRealm> extensionRealms;
        private final int hashCode;

        public CacheKey(List<? extends ClassRealm> extensionRealms) {
            this.extensionRealms = extensionRealms != null ? extensionRealms : Collections.emptyList();
            this.hashCode = ((Object)this.extensionRealms).hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            return ((Object)this.extensionRealms).equals(other.extensionRealms);
        }
    }
}

